/*---------------------------------------------------------------------------------------------------------*/
/*                                                                                                         */
/* SPDX-License-Identifier: Apache-2.0                                                                     */
/* Copyright(c) 2022 Nuvoton Technology Corp. All rights reserved.                                         */
/*                                                                                                         */
/*---------------------------------------------------------------------------------------------------------*/

/************************************************************************************************************/
/*  File Function: MUG51 Watchdog timer interrupt function demo                                              */
/************************************************************************************************************/
#include "MUG51.h"
 
/************************************************************************************************************
*    WDT interrupt sub-routine
************************************************************************************************************/
void WDT_ISR (void)   interrupt 10
{
  _push_(SFRS);
    clr_WDCON_WDTF;
    P32 = ~P32;
  _pop_(SFRS);
}

/************************************************************************************************************
*    Main function 
************************************************************************************************************/
void main (void)
{
/* Note
  WDT timer base is LIRC 10Khz
*/
    P32_QUASI_MODE;
//--------------------------------------------------------
//Warning:
//Pleaes always check CONFIG WDT disable first 
//only when WDT reset disable, WDT use as pure timer
//--------------------------------------------------------
    ENABLE_P17_PULLDOWN;
    WDT_Open(512);
    WDT_Interrupt(Enable);
    ENABLE_GLOBAL_INTERRUPT;
    while (P17)
    {
      set_WDCON_WDCLR;
    }

}
