#!/bin/sh

# tls13-compat.sh
#
# Copyright The Mbed TLS Contributors
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Purpose
#
# List TLS1.3 compat test cases. They are generated by
# `generate_tls13_compat_tests.py -a`.
#
# PLEASE DO NOT EDIT THIS FILE. IF NEEDED, PLEASE MODIFY `generate_tls13_compat_tests.py`
# AND REGENERATE THIS FILE.
#
requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP256R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP384R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-SECP521R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X25519:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_GCM_SHA256,x448,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_GCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_GCM_SHA256,x448,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-GCM:+GROUP-X448:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-GCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1301 ) - TLS1-3-AES-128-GCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp256r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp256r1_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp256r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP256R1:+SHA384:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp384r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp256r1_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp384r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP384R1:+SHA384:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp521r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp256r1_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp521r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP521R1:+SHA384:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x25519,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp256r1_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x25519,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X25519:+SHA384:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x448,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp256r1_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x448,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X448:+SHA384:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp256r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp384r1_sha384 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp256r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP256R1:+SHA384:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp384r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp384r1_sha384 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp384r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP384R1:+SHA384:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp521r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp384r1_sha384 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp521r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP521R1:+SHA384:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x25519,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp384r1_sha384 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x25519,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X25519:+SHA384:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x448,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp384r1_sha384 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x448,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X448:+SHA384:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp256r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp521r1_sha512 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp256r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP256R1:+SHA384:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp384r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp521r1_sha512 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp384r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP384R1:+SHA384:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp521r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp521r1_sha512 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp521r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP521R1:+SHA384:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x25519,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp521r1_sha512 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x25519,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X25519:+SHA384:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x448,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs ecdsa_secp521r1_sha512 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x448,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X448:+SHA384:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp256r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs rsa_pss_rsae_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp256r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP256R1:+SHA384:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp384r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs rsa_pss_rsae_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp384r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP384R1:+SHA384:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,secp521r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs rsa_pss_rsae_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,secp521r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-SECP521R1:+SHA384:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x25519,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs rsa_pss_rsae_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x25519,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X25519:+SHA384:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_256_GCM_SHA384,x448,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_256_GCM_SHA384 -sigalgs rsa_pss_rsae_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_256_GCM_SHA384,x448,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-256-GCM:+GROUP-X448:+SHA384:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-256-GCM-SHA384 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1302 ) - TLS1-3-AES-256-GCM-SHA384" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP256R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP384R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-SECP521R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X25519:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_CHACHA20_POLY1305_SHA256,x448,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_CHACHA20_POLY1305_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_CHACHA20_POLY1305_SHA256,x448,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+CHACHA20-POLY1305:+GROUP-X448:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-CHACHA20-POLY1305-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1303 ) - TLS1-3-CHACHA20-POLY1305-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP256R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP384R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-SECP521R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X25519:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_SHA256,x448,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_SHA256,x448,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM:+GROUP-X448:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1304 ) - TLS1-3-AES-128-CCM-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp256r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp384r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp384r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp521r1,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=secp521r1,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x25519,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x25519,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp256r1.crt -key data_files/ecdsa_secp256r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp256r1_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x448,ecdsa_secp256r1_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp256r1.crt --x509keyfile data_files/ecdsa_secp256r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP256R1-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp256r1_sha256 curves=x448,secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0403 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp256r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp256r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp384r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp521r1,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=secp521r1,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x25519,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x25519,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp384r1.crt -key data_files/ecdsa_secp384r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp384r1_sha384 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x448,ecdsa_secp384r1_sha384" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp384r1.crt --x509keyfile data_files/ecdsa_secp384r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP384R1-SHA384:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp384r1_sha384 curves=x448,secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0503 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp256r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP256R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp256r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp384r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP384R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp384r1,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp521r1,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP521R1:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x25519,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X25519:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x25519,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/ecdsa_secp521r1.crt -key data_files/ecdsa_secp521r1.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs ecdsa_secp521r1_sha512 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x448,ecdsa_secp521r1_sha512" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/ecdsa_secp521r1.crt --x509keyfile data_files/ecdsa_secp521r1.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X448:+SHA256:+SIGN-ECDSA-SECP521R1-SHA512:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca2.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=ecdsa_secp521r1_sha512 curves=x448,secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0603 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-256 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp256r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP256R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp256r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp256r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-384 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp384r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP384R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp384r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp384r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups P-521 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,secp521r1,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-SECP521R1:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=secp521r1" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: secp521r1" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X25519 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x25519,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X25519:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x25519" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x25519" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_openssl_tls1_3
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->O: TLS_AES_128_CCM_8_SHA256,x448,rsa_pss_rsae_sha256" \
         "$O_NEXT_SRV_NO_CERT -cert data_files/server2-sha256.crt -key data_files/server2.key -accept $SRV_PORT -ciphersuites TLS_AES_128_CCM_8_SHA256 -sigalgs rsa_pss_rsae_sha256 -groups X448 -msg -tls1_3 -num_tickets 0 -no_resume_ephemeral -no_cache" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 ok" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"

requires_gnutls_tls1_3
requires_gnutls_next_no_ticket
requires_gnutls_next_disable_tls13_compat
requires_config_enabled MBEDTLS_DEBUG_C
requires_config_enabled MBEDTLS_SSL_CLI_C
requires_config_enabled MBEDTLS_SSL_PROTO_TLS1_3
requires_config_disabled MBEDTLS_USE_PSA_CRYPTO
requires_config_enabled MBEDTLS_SSL_TLS1_3_COMPATIBILITY_MODE
requires_config_enabled MBEDTLS_X509_RSASSA_PSS_SUPPORT
run_test "TLS 1.3 m->G: TLS_AES_128_CCM_8_SHA256,x448,rsa_pss_rsae_sha256" \
         "$G_NEXT_SRV_NO_CERT --http --disable-client-cert --debug=4 --x509certfile data_files/server2-sha256.crt --x509keyfile data_files/server2.key --priority=NONE:+AEAD:+AES-128-CCM-8:+GROUP-X448:+SHA256:+SIGN-RSA-PSS-RSAE-SHA256:+VERS-TLS1.3:%NO_TICKETS" \
         "$P_CLI server_addr=127.0.0.1 server_port=$SRV_PORT debug_level=4 force_version=tls13 ca_file=data_files/test-ca_cat12.crt force_ciphersuite=TLS1-3-AES-128-CCM-8-SHA256 sig_algs=rsa_pss_rsae_sha256 curves=x448" \
         0 \
         -c "HTTP/1.0 200 OK" \
         -c "ECDH curve: x448" \
         -c "server hello, chosen ciphersuite: ( 1305 ) - TLS1-3-AES-128-CCM-8-SHA256" \
         -c "Certificate Verify: Signature algorithm ( 0804 )" \
         -c "Verifying peer X.509 certificate... ok"
