#ifndef INC__HID_HPP__
#define INC__HID_HPP__

#include "stdafx.h"
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <tchar.h>
#include <string.h>
#include "dbt.h"

extern "C" {
#include "setupapi.h"
#include "hidsdi.h"
}


#define HID_MAX_PACKET_SIZE_EP 512
#define V6M_MAX_COMMAND_LENGTH (HID_MAX_PACKET_SIZE_EP - 2)

class CHidIO
{
protected:
	HANDLE m_hReadHandle;
	HANDLE m_hWriteHandle;
	HANDLE m_hReadEvent;
	HANDLE m_hWriteEvent;
	HANDLE m_hAbordEvent;
public:
	CHidIO()
		: m_hReadHandle(INVALID_HANDLE_VALUE)
		, m_hWriteHandle(INVALID_HANDLE_VALUE)
		, m_hAbordEvent(CreateEvent(NULL,TRUE,FALSE,NULL))
		, m_hReadEvent(CreateEvent(NULL,TRUE,FALSE,NULL))
		, m_hWriteEvent(CreateEvent(NULL,TRUE,FALSE,NULL))
	{
	}
	virtual ~CHidIO()
	{
		CloseDevice();
		CloseHandle(m_hWriteEvent);
		CloseHandle(m_hReadEvent);
		CloseHandle(m_hAbordEvent);
	}

	void CloseDevice()
	{
		if(m_hReadHandle != INVALID_HANDLE_VALUE)
			CancelIo(m_hReadHandle);
		if(m_hWriteHandle != INVALID_HANDLE_VALUE)
			CancelIo(m_hWriteHandle);
		if(m_hReadHandle != INVALID_HANDLE_VALUE)
		{
			CloseHandle(m_hReadHandle);
			m_hReadHandle = INVALID_HANDLE_VALUE;
		}
		if(m_hWriteHandle != INVALID_HANDLE_VALUE)
		{
			CloseHandle(m_hWriteHandle);
			m_hWriteHandle = INVALID_HANDLE_VALUE;
		}
	}

	BOOL OpenDevice(USHORT usVID, USHORT usPID)
	{
		//CString MyDevPathName="";
		TCHAR MyDevPathName[MAX_PATH];

		//wq@GUIDcHidGuidӫOsHID]ƪfGUIDC
		GUID HidGuid;
		//wq@DEVINFOy`hDevInfoSetӫOs쪺]ƫHXy`C
		HDEVINFO hDevInfoSet;
		//wqMemberIndexAܷejĴXӳ]ơA0ܲĤ@ӳ]ơC
		DWORD MemberIndex;
		//DevInterfaceDataAΨӫOs]ƪXʱfH
		SP_DEVICE_INTERFACE_DATA DevInterfaceData;
		//wq@BOOLܶqAOsƽեάO_^\
		BOOL Result;
		//wq@RequiredSizeܶqAΨӱݭnOsԲӫHwĪסC
		DWORD RequiredSize;
		//wq@ӫV]ƸԲӫHcwC
		PSP_DEVICE_INTERFACE_DETAIL_DATA	pDevDetailData;
		//wq@ӥΨӫOs}]ƪy`C
		HANDLE hDevHandle;
		//wq@HIDD_ATTRIBUTEScܶqAOs]ƪݩʡC
		HIDD_ATTRIBUTES DevAttributes;
		
		//lƳ]ƥ
		BOOL MyDevFound=FALSE;
		
		//lŪBgy`Lĥy`C
		m_hReadHandle=INVALID_HANDLE_VALUE;
		m_hWriteHandle=INVALID_HANDLE_VALUE;
		
		//DevInterfaceDatac骺cbSizelƬcjp
		DevInterfaceData.cbSize=sizeof(DevInterfaceData);
		//DevAttributesc骺SizelƬcjp
		DevAttributes.Size=sizeof(DevAttributes);
		
		//եHidD_GetHidGuidHID]ƪGUIDAëOsbHidGuidC
		HidD_GetHidGuid(&HidGuid);
		
		//ھHidGuid]ƫHXC䤤FlagsѼƳ]m
		//DIGCF_DEVICEINTERFACE|DIGCF_PRESENTAe̪ܨϥΪGUID
		//fGUIDA̪ܥuC|bϥΪ]ơA]ڭ̳o̥u
		//dwgsW]ơC^y`OsbhDevinfoC`N]
		//HXbϥΧAnϥΨSetupDiDestroyDeviceInfoList
		//PAM|ys|C
		hDevInfoSet=SetupDiGetClassDevs(&HidGuid,
			NULL,
			NULL,
			DIGCF_DEVICEINTERFACE|DIGCF_PRESENT);
		
		//AddToInfOut("}ld]");
		//M]ƶXCӳ]ƶiC|AˬdO_Oڭ̭n䪺]
		//ڭ̫w]ơAΪ̳]Ƥwgd䧹ɡANhXdC
		//VĤ@ӳ]ơAYNMemberIndexm0C
		MemberIndex=0;
		while(1)
		{
			//եSetupDiEnumDeviceInterfacesb]ƫHXs
			//MemberIndex]ƫHC
			Result=SetupDiEnumDeviceInterfaces(hDevInfoSet,
				NULL,
				&HidGuid,
				MemberIndex,
				&DevInterfaceData);
			
			//pGHѡAh]Ƥwgd䧹AhX`C
			if(Result==FALSE) break;
			
			//NMemberIndexVU@ӳ]
			MemberIndex++;
			
			//pGH\Ah~ӳ]ƪԲӫHCb]
			//ԲӫHɡAݭnDOsԲӫHݭnhjwİϡAoqL
			//Ĥ@եΨSetupDiGetDeviceInterfaceDetailCo
			//ѽwİϩM׳NULLѼơAôѤ@ӥΨӫOsݭnhj
			//wİϪܶqRequiredSizeC
			Result=SetupDiGetDeviceInterfaceDetail(hDevInfoSet,
				&DevInterfaceData,
				NULL,
				NULL,
				&RequiredSize,
				NULL);
			
			//MAt@ӤjpRequiredSizewİϡAΨӫOs]ƸԲӫHC
			pDevDetailData=(PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(RequiredSize);
			if(pDevDetailData==NULL) //pGsAh^C
			{
				//MessageBox("s!");
				SetupDiDestroyDeviceInfoList(hDevInfoSet);
				return FALSE;
			}
			
			//ó]mpDevDetailDatacbSizec骺jp]`NuOcjpA
			//]A᭱wİϡ^C
			pDevDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
			
			//MAեSetupDiGetDeviceInterfaceDetailƨ]ƪ
			//ԲӫHCoեγ]mϥΪwİϥHνwİϤjpC
			Result=SetupDiGetDeviceInterfaceDetail(hDevInfoSet,
				&DevInterfaceData,
				pDevDetailData,
				RequiredSize,
				NULL,
				NULL);
			
			//N]Ƹ|ƻsXӡAMPӽЪsC
			//MyDevPathName=pDevDetailData->DevicePath;
			//_tcscpy(MyDevPathName, pDevDetailData->DevicePath);
			wcscpy_s(MyDevPathName, pDevDetailData->DevicePath);
            free(pDevDetailData);
			
			//pGեΥѡAhdU@ӳ]ơC
			if(Result==FALSE) continue;
			
			//pGեΦ\AhϥΤaŪgXݪCreateFile
			//]ƪݩʡA]AVIDBPIDBC
			//@ǿW]ơ]ҦpUSBL^AϥŪXݤ覡OLk}A
			//ӨϥΤaŪgXݪ榡~iH}oǳ]ơAq]ƪݩʡC
			hDevHandle=CreateFile(MyDevPathName, 
				NULL,
				FILE_SHARE_READ|FILE_SHARE_WRITE, 
				NULL,
				OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL,
				NULL);
			
			//pG}\Ah]ݩʡC
			if(hDevHandle!=INVALID_HANDLE_VALUE)
			{
				//]ƪݩʨëOsbDevAttributesc餤
				Result=HidD_GetAttributes(hDevHandle,
					&DevAttributes);
				
				//襴}]
				CloseHandle(hDevHandle);
				
				//ѡAdU@
				if(Result==FALSE) continue;
				
				//pG\AhNݩʤVIDBPIDHγ]ƪPڭ̻ݭn
				//iApG@PܡAhNOڭ̭n䪺]ơC
				if(DevAttributes.VendorID == usVID
					&& DevAttributes.ProductID == usPID){
							MyDevFound=TRUE; //]m]Ƥwg
							//AddToInfOut("]Ƥwg");
							
							//NOڭ̭n䪺]ơAOϥŪg覡}AëOsy`
							//åBܬBXݤ覡C
							
							//Ū覡}]
							m_hReadHandle=CreateFile(MyDevPathName, 
								GENERIC_READ,
								FILE_SHARE_READ|FILE_SHARE_WRITE, 
								NULL,
								OPEN_EXISTING,
								//FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED,
								FILE_ATTRIBUTE_NORMAL,
								NULL);
								//if(hReadHandle!=INVALID_HANDLE_VALUE)AddToInfOut("ŪXݥ}]Ʀ\");
								//else AddToInfOut("ŪXݥ}]ƥ");
							
							//g覡}]
							m_hWriteHandle=CreateFile(MyDevPathName, 
								GENERIC_WRITE,
								FILE_SHARE_READ|FILE_SHARE_WRITE, 
								NULL,
								OPEN_EXISTING,
								//FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED,
								FILE_ATTRIBUTE_NORMAL,
								NULL);
								//if(hWriteHandle!=INVALID_HANDLE_VALUE)AddToInfOut("gXݥ}]Ʀ\");
								//else AddToInfOut("gXݥ}]ƥ");
							
						
							//ĲoƥAŪiu{_BC]boeèSե
							//ŪƾڪơA]N|ް_ƥ󪺲͡AҥHݭnĲo@
							//ƥAŪiu{_BC
							//SetEvent(ReadOverlapped.hEvent);
							
							//ܳ]ƪAC
							//SetDlgItemText(IDC_DS,"]Ƥw}");
							
							//]ơAhX`C{ǥu˴@ӥؼг]ơAdNhX
							//dFCpGAݭnNҦؼг]ƳCXӪܡAiH]m@
							//ƲաANOsbƲդAҦ]Ƴd䧹~hXd
							break;
						}
			}
			//pG}ѡAhdU@ӳ]
			else continue;
		}
		
		//եSetupDiDestroyDeviceInfoListƾP]ƫHX
		SetupDiDestroyDeviceInfoList(hDevInfoSet);
		
		//pG]ƤwgAӨϯUާ@sAæPɸT}]ƫs
		return MyDevFound;
	}


	BOOL ReadFile(char *pcBuffer, DWORD szMaxLen, DWORD *pdwLength, DWORD dwMilliseconds)
	{
		HANDLE events[2] = {m_hAbordEvent, m_hReadEvent};

		OVERLAPPED overlapped;
		memset(&overlapped, 0, sizeof(overlapped));
		overlapped.hEvent = m_hReadEvent;

		if(pdwLength != NULL)
			*pdwLength = 0;
		
		if(!::ReadFile(m_hReadHandle, pcBuffer, szMaxLen, NULL, &overlapped))
			return FALSE;
		DWORD dwIndex = WaitForMultipleObjects(2, events, FALSE, dwMilliseconds);
		if(dwIndex == WAIT_OBJECT_0
			|| dwIndex == WAIT_OBJECT_0 + 1)
		{
			ResetEvent(events[dwIndex - WAIT_OBJECT_0]);

			if(dwIndex == WAIT_OBJECT_0)
				return FALSE;	//Abort event
			else
			{
				DWORD dwLength = 0;
				//Read OK
				GetOverlappedResult(m_hReadHandle, &overlapped, &dwLength, TRUE);
				if(pdwLength != NULL)
					*pdwLength = dwLength;
				return TRUE;
			}				
		}
		else
			return FALSE;
	}

	BOOL WriteFile(const char *pcBuffer, DWORD szLen, DWORD *pdwLength, DWORD dwMilliseconds)
	{
		HANDLE events[2] = {m_hAbordEvent, m_hWriteEvent};
        
		OVERLAPPED overlapped;
		memset(&overlapped, 0, sizeof(overlapped));
		overlapped.hEvent = m_hWriteEvent;

		if(pdwLength != NULL)
			*pdwLength = 0;

		DWORD dwStart2 = GetTickCount();

		if(!::WriteFile(m_hWriteHandle, pcBuffer, szLen, NULL, &overlapped))
			return FALSE;

		DWORD dwIndex = WaitForMultipleObjects(2, events, FALSE, dwMilliseconds);
		
		if(dwIndex == WAIT_OBJECT_0
			|| dwIndex == WAIT_OBJECT_0 + 1)
		{
			ResetEvent(events[dwIndex - WAIT_OBJECT_0]);

			if(dwIndex == WAIT_OBJECT_0)
				return FALSE;	//Abort event
			else
			{
				DWORD dwLength = 0;
				//Write OK
				GetOverlappedResult(m_hWriteHandle, &overlapped, &dwLength, TRUE);
				if(pdwLength != NULL)
					*pdwLength = dwLength;
				return TRUE;
			}				
		}
		else
			return FALSE;
	}
};



class CHidCmd
{
protected:
	CHAR	m_acBuffer[HID_MAX_PACKET_SIZE_EP + 1];
	CHidIO	m_hidIO;
public:
	CHidCmd()
		: m_hidIO()
	{
	}
	virtual ~CHidCmd()
	{
	}

	void CloseDevice()
	{
		m_hidIO.CloseDevice();
	}

	BOOL OpenDevice(USHORT usVID, USHORT usPID)
	{
		return m_hidIO.OpenDevice(usVID, usPID);
	}

	BOOL ReadFile(unsigned char *pcBuffer, size_t szMaxLen, DWORD *pdwLength, DWORD dwMilliseconds)
	{
        BOOL bRet;

        bRet = m_hidIO.ReadFile(m_acBuffer, sizeof(m_acBuffer), pdwLength, dwMilliseconds);
        (*pdwLength)--;
        memcpy(pcBuffer, m_acBuffer+1, *pdwLength);

		return bRet;
	}

	BOOL WriteFile(unsigned char *pcBuffer, DWORD dwLen, DWORD *pdwLength, DWORD dwMilliseconds)
	{
		/* Set new package index value */
		DWORD dwCmdLength = dwLen;
		if(dwCmdLength > sizeof(m_acBuffer) - 1)
			dwCmdLength = sizeof(m_acBuffer) - 1;
        
        memset(m_acBuffer, 0xCC, sizeof(m_acBuffer));
		m_acBuffer[0] = 0x00;	//Always 0x00
        memcpy(m_acBuffer+1  , pcBuffer, dwCmdLength);
		BOOL bRet = m_hidIO.WriteFile(m_acBuffer, HID_MAX_PACKET_SIZE_EP+1, pdwLength, dwMilliseconds);
        if(bRet)
        {
                *pdwLength = *pdwLength - 1;
        }

        return bRet;
	}

};



#endif
