/*---------------------------------------------------------------------------------------------------------*/
/*                                                                                                         */
/* SPDX-License-Identifier: Apache-2.0                                                                     */
/* Copyright(c) 2020 Nuvoton Technology Corp. All rights reserved.                                         */
/*                                                                                                         */
/*---------------------------------------------------------------------------------------------------------*/

/***********************************************************************************************************/
/*  Website: http://www.nuvoton.com                                                                        */
/*  E-Mail : MicroC-8bit@nuvoton.com                                                                       */
/*  Date   : June/21/2020                                                                                   */
/***********************************************************************************************************/
#include "MS51_32K.h"
bit PRINTFG = 0, uart0_receive_flag = 0, uart1_receive_flag;
unsigned char uart0_receive_data, uart1_receive_data;


void Serial_ISR(void) interrupt 4
{
    _push_(SFRS);
    if (RI)
    {
        uart0_receive_flag = 1;
        uart0_receive_data = SBUF;
        clr_SCON_RI;                                         // Clear RI (Receive Interrupt).
    }

    if (TI)
    {
//        if (!PRINTFG)
//        {
//            TI = 0;
//        }
    }
    _pop_(SFRS);
}  



void SerialPort1_ISR(void) interrupt 15
{
    _push_(SFRS);

    if (RI_1 == 1)
    {
        clr_SCON_1_RI_1;                             /* clear reception flag for next reception */
        uart1_receive_data = SBUF_1;
        uart1_receive_flag = 1;
    }

    if (TI_1 == 1)
    {
        if (!PRINTFG)
        {
            clr_SCON_1_TI_1;                             /* if emission occur */
        }
    }
    _pop_(SFRS);
}  

/*MS51 new version buadrate */
void UART_Open(unsigned long u32SysClock, unsigned char u8UARTPort, unsigned long u32Baudrate)
{
     SFRS = 0;
     switch (u8UARTPort)
    {
        case UART0_Timer1:
            SCON = 0x50;            //UART0 Mode1,REN=1,TI=1
            TMOD |= 0x20;           //Timer1 Mode1
            set_PCON_SMOD;          //UART0 Double Rate Enable
            set_CKCON_T1M;
            clr_T3CON_BRCK;          //Serial port 0 baud rate clock source = Timer1
            TH1 = 256 - (u32SysClock / 16 / u32Baudrate);
            set_TCON_TR1;
            set_IE_ES;
            break;

        case UART0_Timer3:
            SCON = 0x50;          //UART0 Mode1,REN=1,TI=1
            set_PCON_SMOD;        //UART0 Double Rate Enable
            T3CON &= 0xF8;        //T3PS2=0,T3PS1=0,T3PS0=0(Prescale=1)
            set_T3CON_BRCK;        //UART0 baud rate clock source = Timer3
            RH3    = HIBYTE(65536 - (u32SysClock / 16 / u32Baudrate));
            RL3    = LOBYTE(65536 - (u32SysClock / 16 / u32Baudrate));
            set_T3CON_TR3;         //Trigger Timer3
            set_IE_ES;
            break;

        case UART1_Timer3:
            SCON_1 = 0x50;          //UART1 Mode1,REN_1=1,TI_1=1
            T3CON = 0x80;           //T3PS2=0,T3PS1=0,T3PS0=0(Prescale=1), UART1 in MODE 1
            RH3    = HIBYTE(65536 - (u32SysClock/16/u32Baudrate));  
            RL3    = LOBYTE(65536 - (u32SysClock/16/u32Baudrate));     
            set_T3CON_TR3;             //Trigger Timer3
            set_EIE1_ES_1;
            break;
    }
 }

unsigned char Receive_Data(unsigned char UARTPort)
{
    UINT8 c;
    SFRS = 0;
    switch (UARTPort)
    {
        case UART0:
            while (!RI);
            c = SBUF;
            RI = 0;
            break;

        case UART1:
            while (!RI_1);
            c = SBUF_1;
            RI_1 = 0;
            break;
    }

    return (c);
}

void UART_Send_Data(unsigned char UARTPort, unsigned char c)
{
    _push_(SFRS);
    SFRS = 0;
    switch (UARTPort)
    {
        case UART0:
          TI=0;
          SBUF = c;
          while(!TI);
        break;
        case UART1:
          TI_1=0;
          SBUF_1 = c;
          while(TI_1);
        break;
    }
    _pop_(SFRS);
}


void Enable_UART0_VCOM_printf_24M_115200(void)
{
    P06_QUASI_MODE;
    UART_Open(24000000,UART0_Timer1,115200);
    ENABLE_UART0_PRINTF;
}
