/*---------------------------------------------------------------------------------------------------------*/
/*                                                                                                         */
/* SPDX-License-Identifier: Apache-2.0                                                                     */
/* Copyright(c) 2020 Nuvoton Technology Corp. All rights reserved.                                         */
/*                                                                                                         */
/*---------------------------------------------------------------------------------------------------------*/


/************************************************************************************************************/
/*  File Function: MS51 Timer 2 delay with interrupt demo                                                   */
/************************************************************************************************************/
#include "MS51_32K.h"

/************************************************************************************************************
*    Timer2 interrupt subroutine
************************************************************************************************************/
void Timer2_ISR (void) interrupt 5
{
    _push_(SFRS);
  
    clr_T2CON_TF2;                                //Clear Timer2 Interrupt Flag
    P35 = ~ P35;
  
    _pop_(SFRS);
}	
/************************************************************************************************************
*    Main function 
************************************************************************************************************/
void main (void)
{
    P35_PUSHPULL_MODE;

    TIMER2_DIV_128;
    TIMER2_Auto_Reload_Delay_Mode;
  
    RCMP2H = 0x60;
    RCMP2L = 0xFF;

    TL2 = 0x60;
    TH2 = 0xFF;

    set_EIE_ET2;                                    // Enable Timer2 interrupt
    set_IE_EA;
    set_T2CON_TR2;                                    // Timer2 run

    while(1)
    {
      set_T2CON_TR2;
    }

}
