<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile doxygen_version="1.9.6" doxygen_gitid="4586b5cfaa3d46d51f6a51882951d15644c49edf">
  <compound kind="struct">
    <name>osEventFlagsAttr_t</name>
    <filename>group__CMSIS__RTOS__EventFlags.html</filename>
    <anchor>structosEventFlagsAttr__t</anchor>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>ab74e6bf80237ddc4109968cedc58c151</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>attr_bits</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>a6e93b49cb79c12f768d72580c7731f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>cb_mem</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>a1e100dc33d403841ed3c344e3397868e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>cb_size</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>aa55a4335d12dc2785dc00fdc292d1159</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osMemoryPoolAttr_t</name>
    <filename>group__CMSIS__RTOS__PoolMgmt.html</filename>
    <anchor>structosMemoryPoolAttr__t</anchor>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>ab74e6bf80237ddc4109968cedc58c151</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>attr_bits</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>a6e93b49cb79c12f768d72580c7731f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>cb_mem</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>a1e100dc33d403841ed3c344e3397868e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>cb_size</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>aa55a4335d12dc2785dc00fdc292d1159</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>mp_mem</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>a5799465cca9c71c5587ceb0986f5b06a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>mp_size</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>a66c26015c0ac8e88a4ad907c120aee4f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osMessageQueueAttr_t</name>
    <filename>group__CMSIS__RTOS__Message.html</filename>
    <anchor>structosMessageQueueAttr__t</anchor>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>ab74e6bf80237ddc4109968cedc58c151</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>attr_bits</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>a6e93b49cb79c12f768d72580c7731f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>cb_mem</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>a1e100dc33d403841ed3c344e3397868e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>cb_size</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>aa55a4335d12dc2785dc00fdc292d1159</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>mq_mem</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>a4e208dc0fb049b42c4b90cbd2791c5ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>mq_size</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>ac1cc09f875e20c926920b57bb83c70ee</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osMutexAttr_t</name>
    <filename>group__CMSIS__RTOS__MutexMgmt.html</filename>
    <anchor>structosMutexAttr__t</anchor>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>ab74e6bf80237ddc4109968cedc58c151</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>attr_bits</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>a6e93b49cb79c12f768d72580c7731f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>cb_mem</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>a1e100dc33d403841ed3c344e3397868e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>cb_size</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>aa55a4335d12dc2785dc00fdc292d1159</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osSemaphoreAttr_t</name>
    <filename>group__CMSIS__RTOS__SemaphoreMgmt.html</filename>
    <anchor>structosSemaphoreAttr__t</anchor>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ab74e6bf80237ddc4109968cedc58c151</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>attr_bits</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>a6e93b49cb79c12f768d72580c7731f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>cb_mem</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>a1e100dc33d403841ed3c344e3397868e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>cb_size</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>aa55a4335d12dc2785dc00fdc292d1159</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osThreadAttr_t</name>
    <filename>group__CMSIS__RTOS__ThreadMgmt.html</filename>
    <anchor>structosThreadAttr__t</anchor>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ab74e6bf80237ddc4109968cedc58c151</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>attr_bits</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>a6e93b49cb79c12f768d72580c7731f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>cb_mem</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>a1e100dc33d403841ed3c344e3397868e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>cb_size</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>aa55a4335d12dc2785dc00fdc292d1159</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>stack_mem</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ad7c9b42355a4c8b9467130ab3fb19e43</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>stack_size</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>aacbc9a219f2d6870e9ce89bb93f975c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>osPriority_t</type>
      <name>priority</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>a6a5183df4c54c3e28dc8dc704f2487d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>TZ_ModuleId_t</type>
      <name>tz_module</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>a697f2aad6119d655d212ea10245ae394</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>affinity_mask</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>aaf358099120136bf63c5e53cf5d40043</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osTimerAttr_t</name>
    <filename>group__CMSIS__RTOS__TimerMgmt.html</filename>
    <anchor>structosTimerAttr__t</anchor>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>ab74e6bf80237ddc4109968cedc58c151</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>attr_bits</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>a6e93b49cb79c12f768d72580c7731f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>cb_mem</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>a1e100dc33d403841ed3c344e3397868e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>cb_size</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>aa55a4335d12dc2785dc00fdc292d1159</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osVersion_t</name>
    <filename>group__CMSIS__RTOS__KernelCtrl.html</filename>
    <anchor>structosVersion__t</anchor>
    <member kind="variable">
      <type>uint32_t</type>
      <name>api</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>a76a1ef1a4d3d9bd3e70783051f22a6d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>kernel</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ad8075d3f42141346ae2c56389358f9e7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS</name>
    <title>CMSIS-RTOS2 API</title>
    <filename>group__CMSIS__RTOS.html</filename>
    <subgroup>CMSIS_RTOS_KernelCtrl</subgroup>
    <subgroup>CMSIS_RTOS_ThreadMgmt</subgroup>
    <subgroup>CMSIS_RTOS_ThreadFlagsMgmt</subgroup>
    <subgroup>CMSIS_RTOS_EventFlags</subgroup>
    <subgroup>CMSIS_RTOS_Wait</subgroup>
    <subgroup>CMSIS_RTOS_TimerMgmt</subgroup>
    <subgroup>CMSIS_RTOS_MutexMgmt</subgroup>
    <subgroup>CMSIS_RTOS_SemaphoreMgmt</subgroup>
    <subgroup>CMSIS_RTOS_PoolMgmt</subgroup>
    <subgroup>CMSIS_RTOS_Message</subgroup>
    <subgroup>CMSIS_RTOS_Definitions</subgroup>
    <docanchor file="group__CMSIS__RTOS.html" title="CMSIS-RTOS2 Function Reference">rtos_api2_functions</docanchor>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_KernelCtrl</name>
    <title>Kernel Information and Control</title>
    <filename>group__CMSIS__RTOS__KernelCtrl.html</filename>
    <class kind="struct">osVersion_t</class>
    <member kind="enumeration">
      <type></type>
      <name>osKernelState_t</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga08326469274b668140ca934b168a5ad4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osKernelInactive</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gga08326469274b668140ca934b168a5ad4a2ad3e5912db47b497529d036c89e7995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osKernelReady</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gga08326469274b668140ca934b168a5ad4a0596c6e14113447604753656417c9a24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osKernelRunning</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gga08326469274b668140ca934b168a5ad4a8e0b699fbe1c8bb66fefadd5911cb6ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osKernelLocked</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gga08326469274b668140ca934b168a5ad4a2fe382ad5ebab2257b35740414b28b01</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osKernelSuspended</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gga08326469274b668140ca934b168a5ad4ad364464ad84d63b1413a9ac8a962390c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osKernelError</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gga08326469274b668140ca934b168a5ad4a0545c92c18ce8e6b24e82a0d694a0b4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osKernelReserved</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gga08326469274b668140ca934b168a5ad4ab0a47576defa29396a649d9173d4bc4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osKernelInitialize</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gae818f6611d25ba3140bede410a52d659</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osKernelGetInfo</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga6f7764e7250c5c5364c00c45a5d1d199</anchor>
      <arglist>(osVersion_t *version, char *id_buf, uint32_t id_size)</arglist>
    </member>
    <member kind="function">
      <type>osKernelState_t</type>
      <name>osKernelGetState</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga48b69b81012fce051f639be288b243ba</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osKernelStart</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga9ae2cc00f0d89d7b6a307bba942b5221</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>osKernelLock</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga948609ee930d9b38336b9e1c2a4dfe12</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>osKernelUnlock</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gaf401728b4657456198c33fe75f8d6720</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>osKernelRestoreLock</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gae7d0a71b9586cbbb49fcbdf6a04f0289</anchor>
      <arglist>(int32_t lock)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osKernelSuspend</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gae26683e1606ec633354a2876c68f0c1f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osKernelResume</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga8c4b4d7ed34cab73c001665d9176aced</anchor>
      <arglist>(uint32_t sleep_ticks)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osKernelGetTickCount</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga84bcdbf2fb76b10c8df4e439f0c7e11b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osKernelGetTickFreq</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga7a8d7bd927eaaa58999f91d7d6310cee</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osKernelGetSysTimerCount</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gae0fcaff6cecfb4013bb556c87afcd7d2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osKernelGetSysTimerFreq</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga4d69215a93220f72be3684cad582f16a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osKernelProtect</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>gac7e3b012c15c55bda68e0dd96ad9cd72</anchor>
      <arglist>(uint32_t safety_class)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osKernelDestroyClass</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga2065364d1bc805a40e749430377df1e1</anchor>
      <arglist>(uint32_t safety_class, uint32_t mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osFaultResume</name>
      <anchorfile>group__CMSIS__RTOS__KernelCtrl.html</anchorfile>
      <anchor>ga91b400b21a9093f7751fc45613c12110</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_ThreadMgmt</name>
    <title>Thread Management</title>
    <filename>group__CMSIS__RTOS__ThreadMgmt.html</filename>
    <class kind="struct">osThreadAttr_t</class>
    <member kind="define">
      <type>#define</type>
      <name>osErrorId</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga6f3bd4b67fb89bd085266fe65ee45b06</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osThreadJoinable</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga249499c519f3f8eef5673009ab6cfcbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osThreadDetached</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gaa9336c1073858d6b118e2e011636246f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osThreadUnprivileged</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga4c028e5c3f4d86d237a1e09ceaf84792</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osThreadPrivileged</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga7c2b7db42d23e4f56132e0ed739d02e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osThreadZone</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gaefca370070d0b1616421bc3311acfecc</anchor>
      <arglist>(n)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osThreadProcessor</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga4ef461379ceba9ab7764850ef2c7b0ac</anchor>
      <arglist>(n)</arglist>
    </member>
    <member kind="typedef">
      <type>void(*</type>
      <name>osThreadFunc_t</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gadd51f99a6eb50b94eee75f27cae815eb</anchor>
      <arglist>)(void *argument)</arglist>
    </member>
    <member kind="typedef">
      <type>void *</type>
      <name>osThreadId_t</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gaa6c32fe2a3e0a2e01f212d55b02e51c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>osThreadState_t</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gad3dc89e942e38d9f3af858a0269a820d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osThreadInactive</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad3dc89e942e38d9f3af858a0269a820dae9d77830b6866e287417b6e1d983e971</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osThreadReady</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad3dc89e942e38d9f3af858a0269a820da59e286915944fe0e4d1ffdb1f2946f14</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osThreadRunning</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad3dc89e942e38d9f3af858a0269a820dac4fe336e0790188fcf7d667372eca19d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osThreadBlocked</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad3dc89e942e38d9f3af858a0269a820daf0e992e354fba8695957c530226a4968</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osThreadTerminated</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad3dc89e942e38d9f3af858a0269a820dad5b2726c2d0228f4f1a76cf6b630963c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osThreadError</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad3dc89e942e38d9f3af858a0269a820da339313e26613bc12f66a852e2ff8745e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>osPriority_t</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gad4e3e0971b41f2d17584a8c6837342ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osPriorityIdle</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad4e3e0971b41f2d17584a8c6837342ecacd5864eac01a6916a7c866bb51a6aac1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osPriorityISR</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ggad4e3e0971b41f2d17584a8c6837342eca4b4fa46c3ebaf4259662a0a0a3173b7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>osThreadId_t</type>
      <name>osThreadNew</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga48d68b8666d99d28fa646ee1d2182b8f</anchor>
      <arglist>(osThreadFunc_t func, void *argument, const osThreadAttr_t *attr)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osThreadGetName</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gac3230f3a55a297514b013ebf38f27e0a</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadGetClass</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga1bfbef7da94ed4147d231e8d6eeb5f3e</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadGetZone</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga4101737fa4fd303d4b41fdca6b994f8e</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>osThreadId_t</type>
      <name>osThreadGetId</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga8df03548e89fbc56402a5cd584a505da</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>osThreadState_t</type>
      <name>osThreadGetState</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gacc0a98b42f0a5928e12dc91dc76866b9</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadSetPriority</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga861a420fb2d643115b06622903fb3bfb</anchor>
      <arglist>(osThreadId_t thread_id, osPriority_t priority)</arglist>
    </member>
    <member kind="function">
      <type>osPriority_t</type>
      <name>osThreadGetPriority</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga0aeaf349604f456e68e78f9d3b42e44b</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadYield</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gad01c7ec26535b1de6b018bb9466720e2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadSuspend</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gaa9de419d0152bf77e9bbcd1f369fb990</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadResume</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga3dbad90eff394b02de76a452c84c5d80</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadDetach</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gaaad14cd9547341ea8109dc4e8540f1dc</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadJoin</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga3fca90fb0679afeb968aa8c3d5874487</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>__NO_RETURN void</type>
      <name>osThreadExit</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gaddaa452dd7610e4096647a566d3556fc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadTerminate</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga2f8ba6dba6e9c065a6e236ffd410d74a</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadGetStackSize</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gab9f8bd715d671c6ee27644867bc1bf65</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadGetStackSpace</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga9c83bd5dd8de329701775d6ef7012720</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadGetCount</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga495b3f812224e7301f23a691793765db</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadEnumerate</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga5606604d56e21ece1a654664be877439</anchor>
      <arglist>(osThreadId_t *thread_array, uint32_t array_items)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadFeedWatchdog</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga8f4455b06afb95c1915f15266818a8c6</anchor>
      <arglist>(uint32_t ticks)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadProtectPrivileged</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gaee8e6bed82cd58dad31bb90156182032</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadSuspendClass</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gadadb56627094dbb07f6aeddf7d713fd9</anchor>
      <arglist>(uint32_t safety_class, uint32_t mode)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadResumeClass</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gadd0a06b459925eb5cdeab67b380a3970</anchor>
      <arglist>(uint32_t safety_class, uint32_t mode)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadTerminateZone</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga99ce311cc620c65fbac043d04dc7d755</anchor>
      <arglist>(uint32_t zone)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osThreadSetAffinityMask</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga60e2518df0194587a134b7e1836f2470</anchor>
      <arglist>(osThreadId_t thread_id, uint32_t affinity_mask)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadGetAffinityMask</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>gab0541a97b969f7f762572dcefe2f65e1</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osWatchdogAlarm_Handler</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga5a02770aaf65c7a3c7562c109884176a</anchor>
      <arglist>(osThreadId_t thread_id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osZoneSetup_Callback</name>
      <anchorfile>group__CMSIS__RTOS__ThreadMgmt.html</anchorfile>
      <anchor>ga79d4b26de0bfcdaf142f83e585532f93</anchor>
      <arglist>(uint32_t zone)</arglist>
    </member>
    <docanchor file="group__CMSIS__RTOS__ThreadMgmt.html">ThreadStates</docanchor>
    <docanchor file="group__CMSIS__RTOS__ThreadMgmt.html">threadConfig_procmode</docanchor>
    <docanchor file="group__CMSIS__RTOS__ThreadMgmt.html">thread_examples</docanchor>
    <docanchor file="group__CMSIS__RTOS__ThreadMgmt.html">joinable_threads</docanchor>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_ThreadFlagsMgmt</name>
    <title>Thread Flags</title>
    <filename>group__CMSIS__RTOS__ThreadFlagsMgmt.html</filename>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadFlagsSet</name>
      <anchorfile>group__CMSIS__RTOS__ThreadFlagsMgmt.html</anchorfile>
      <anchor>ga6f89ef9caded1d9963c7b12b0f6412c9</anchor>
      <arglist>(osThreadId_t thread_id, uint32_t flags)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadFlagsClear</name>
      <anchorfile>group__CMSIS__RTOS__ThreadFlagsMgmt.html</anchorfile>
      <anchor>ga656abc1c862c5b9a2b13584c42cc0bfa</anchor>
      <arglist>(uint32_t flags)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadFlagsGet</name>
      <anchorfile>group__CMSIS__RTOS__ThreadFlagsMgmt.html</anchorfile>
      <anchor>ga85c8d2c89466e25abbcb545d9ddd71ba</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osThreadFlagsWait</name>
      <anchorfile>group__CMSIS__RTOS__ThreadFlagsMgmt.html</anchorfile>
      <anchor>gac11542ad6300b600f872fc96e340ec2b</anchor>
      <arglist>(uint32_t flags, uint32_t options, uint32_t timeout)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_EventFlags</name>
    <title>Event Flags</title>
    <filename>group__CMSIS__RTOS__EventFlags.html</filename>
    <class kind="struct">osEventFlagsAttr_t</class>
    <member kind="typedef">
      <type>void *</type>
      <name>osEventFlagsId_t</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>gafdbab933146d6d81d7cca7287e267a50</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>osEventFlagsId_t</type>
      <name>osEventFlagsNew</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>gab14b1caeb12ffa42cce1bfe889cd07df</anchor>
      <arglist>(const osEventFlagsAttr_t *attr)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osEventFlagsSet</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>ga33b71d14cecf90b4e72639dd19f23a5e</anchor>
      <arglist>(osEventFlagsId_t ef_id, uint32_t flags)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osEventFlagsClear</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>ga93bf258ca0007c6641fbe8e4f2b8a1e5</anchor>
      <arglist>(osEventFlagsId_t ef_id, uint32_t flags)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osEventFlagsGet</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>ga8bda3185f46bfd278cea8a6cf357677d</anchor>
      <arglist>(osEventFlagsId_t ef_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osEventFlagsWait</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>ga52acb34a8322e58020227344fe662b4e</anchor>
      <arglist>(osEventFlagsId_t ef_id, uint32_t flags, uint32_t options, uint32_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osEventFlagsDelete</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>ga7c4acf2fb0d506ec82905dee53fb5435</anchor>
      <arglist>(osEventFlagsId_t ef_id)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osEventFlagsGetName</name>
      <anchorfile>group__CMSIS__RTOS__EventFlags.html</anchorfile>
      <anchor>ga59f4ddf0ee8c395b1672bb978d1cfc88</anchor>
      <arglist>(osEventFlagsId_t ef_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_Wait</name>
    <title>Generic Wait Functions</title>
    <filename>group__CMSIS__RTOS__Wait.html</filename>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osDelay</name>
      <anchorfile>group__CMSIS__RTOS__Wait.html</anchorfile>
      <anchor>gaf6055a51390ef65b6b6edc28bf47322e</anchor>
      <arglist>(uint32_t ticks)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osDelayUntil</name>
      <anchorfile>group__CMSIS__RTOS__Wait.html</anchorfile>
      <anchor>ga3c807924c2d6d43bc2ffb49da3f7f3a1</anchor>
      <arglist>(uint32_t ticks)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_TimerMgmt</name>
    <title>Timer Management</title>
    <filename>group__CMSIS__RTOS__TimerMgmt.html</filename>
    <class kind="struct">osTimerAttr_t</class>
    <member kind="typedef">
      <type>void *</type>
      <name>osTimerId_t</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gaad5409379689ee27bb0a0b56ea4a4b34</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void(*</type>
      <name>osTimerFunc_t</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gaacf768c1ec64b020598afb985d7b30be</anchor>
      <arglist>)(void *argument)</arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>osTimerType_t</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>ga7dc24a4c2b90334427081c3da7a71915</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osTimerOnce</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gga7dc24a4c2b90334427081c3da7a71915a2e0e1f31c742c84b497c4d7143357bdb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osTimerPeriodic</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gga7dc24a4c2b90334427081c3da7a71915ab3463d921dc310938094745c230f2b35</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>osTimerId_t</type>
      <name>osTimerNew</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gad4e7f785c5f700a509f55a3bf6a62bec</anchor>
      <arglist>(osTimerFunc_t func, osTimerType_t type, void *argument, const osTimerAttr_t *attr)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osTimerGetName</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>ga7938dde88ada1a01b60f41cf120069c0</anchor>
      <arglist>(osTimerId_t timer_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osTimerStart</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gab6ee2859ea657641b7adfac599b8121d</anchor>
      <arglist>(osTimerId_t timer_id, uint32_t ticks)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osTimerStop</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gabd7a89356da7717293eb0bc5d87b8ac9</anchor>
      <arglist>(osTimerId_t timer_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osTimerIsRunning</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>ga69d3589f54194022c30dd01e45ec6741</anchor>
      <arglist>(osTimerId_t timer_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osTimerDelete</name>
      <anchorfile>group__CMSIS__RTOS__TimerMgmt.html</anchorfile>
      <anchor>gad0001dd74721ab461789324806db2453</anchor>
      <arglist>(osTimerId_t timer_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_MutexMgmt</name>
    <title>Mutex Management</title>
    <filename>group__CMSIS__RTOS__MutexMgmt.html</filename>
    <class kind="struct">osMutexAttr_t</class>
    <member kind="define">
      <type>#define</type>
      <name>osMutexRecursive</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>ga65c2482cc64a35d03871f3180f305926</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osMutexPrioInherit</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>ga40fba270cb31a977b3bd551d41eb9599</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osMutexRobust</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>gaf0e1dee376798b4d516d164981526780</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void *</type>
      <name>osMutexId_t</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>ga313801836c62deb23055efb55a420e42</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>osMutexId_t</type>
      <name>osMutexNew</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>gab90920022ab944296821368ef6bb52f8</anchor>
      <arglist>(const osMutexAttr_t *attr)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osMutexGetName</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>ga00b5e58cd247a412d1afd18732d8b752</anchor>
      <arglist>(osMutexId_t mutex_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMutexAcquire</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>gabc54686ea0fc281823b1763422d2a924</anchor>
      <arglist>(osMutexId_t mutex_id, uint32_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMutexRelease</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>gaea629705703580ff58776bf73c8db915</anchor>
      <arglist>(osMutexId_t mutex_id)</arglist>
    </member>
    <member kind="function">
      <type>osThreadId_t</type>
      <name>osMutexGetOwner</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>ga7f9a7666df0978738cd570cb700b83fb</anchor>
      <arglist>(osMutexId_t mutex_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMutexDelete</name>
      <anchorfile>group__CMSIS__RTOS__MutexMgmt.html</anchorfile>
      <anchor>gabee73ad227ba4587d3db12ef9bd582bc</anchor>
      <arglist>(osMutexId_t mutex_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_SemaphoreMgmt</name>
    <title>Semaphores</title>
    <filename>group__CMSIS__RTOS__SemaphoreMgmt.html</filename>
    <class kind="struct">osSemaphoreAttr_t</class>
    <member kind="typedef">
      <type>void *</type>
      <name>osSemaphoreId_t</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ga6e1c1c4b04175bb92b013c8f37249f40</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>osSemaphoreId_t</type>
      <name>osSemaphoreNew</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ga2a39806ace781a0008a4374ca701b14a</anchor>
      <arglist>(uint32_t max_count, uint32_t initial_count, const osSemaphoreAttr_t *attr)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osSemaphoreGetName</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ga9586952051f00285f1482dbe6695bbc4</anchor>
      <arglist>(osSemaphoreId_t semaphore_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osSemaphoreAcquire</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ga7e94c8b242a0c81f2cc79ec22895c87b</anchor>
      <arglist>(osSemaphoreId_t semaphore_id, uint32_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osSemaphoreRelease</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ga0abcee1b5449d7a6928fb9248c690bb6</anchor>
      <arglist>(osSemaphoreId_t semaphore_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osSemaphoreGetCount</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ga7559d4dff3cda9992fc5ab5de3e74c70</anchor>
      <arglist>(osSemaphoreId_t semaphore_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osSemaphoreDelete</name>
      <anchorfile>group__CMSIS__RTOS__SemaphoreMgmt.html</anchorfile>
      <anchor>ga81258ce9c67fa89f07cc49d2e136cd88</anchor>
      <arglist>(osSemaphoreId_t semaphore_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_PoolMgmt</name>
    <title>Memory Pool</title>
    <filename>group__CMSIS__RTOS__PoolMgmt.html</filename>
    <class kind="struct">osMemoryPoolAttr_t</class>
    <member kind="typedef">
      <type>void *</type>
      <name>osMemoryPoolId_t</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>ga2e44473caf338266f56800960294f960</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>osMemoryPoolId_t</type>
      <name>osMemoryPoolNew</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>ga497ced5d72dc5cd405c4c418516220dc</anchor>
      <arglist>(uint32_t block_count, uint32_t block_size, const osMemoryPoolAttr_t *attr)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osMemoryPoolGetName</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>gab414a1e138205a55820acfa277c8f386</anchor>
      <arglist>(osMemoryPoolId_t mp_id)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osMemoryPoolAlloc</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>ga8ead54e99ccb8f112356c88f99d38fbe</anchor>
      <arglist>(osMemoryPoolId_t mp_id, uint32_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMemoryPoolFree</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>gabb4f4560daa6d1f8c8789082ee186d16</anchor>
      <arglist>(osMemoryPoolId_t mp_id, void *block)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMemoryPoolGetCapacity</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>gad696e94bfbe28f0b6613f9303fdf6a37</anchor>
      <arglist>(osMemoryPoolId_t mp_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMemoryPoolGetBlockSize</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>gab2bf059b7fa7679c3cccdaeec60b6c0e</anchor>
      <arglist>(osMemoryPoolId_t mp_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMemoryPoolGetCount</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>ga958a9449bff8c95ce213de98eef5739d</anchor>
      <arglist>(osMemoryPoolId_t mp_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMemoryPoolGetSpace</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>ga0394cffa9479a7994e3b03c79c1cb909</anchor>
      <arglist>(osMemoryPoolId_t mp_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMemoryPoolDelete</name>
      <anchorfile>group__CMSIS__RTOS__PoolMgmt.html</anchorfile>
      <anchor>ga8c39e7e5cd2b9eda907466808e59d62e</anchor>
      <arglist>(osMemoryPoolId_t mp_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_Message</name>
    <title>Message Queue</title>
    <filename>group__CMSIS__RTOS__Message.html</filename>
    <class kind="struct">osMessageQueueAttr_t</class>
    <member kind="function">
      <type>osMessageQueueId_t</type>
      <name>osMessageQueueNew</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>ga24e895a00f9d484db33aaf784c57bfed</anchor>
      <arglist>(uint32_t msg_count, uint32_t msg_size, const osMessageQueueAttr_t *attr)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osMessageQueueGetName</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>gae7cf7bf2b97a5ae481fb60fcce99247a</anchor>
      <arglist>(osMessageQueueId_t mq_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMessageQueuePut</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>gaa515fc8b956f721a8f72b2c505813bfc</anchor>
      <arglist>(osMessageQueueId_t mq_id, const void *msg_ptr, uint8_t msg_prio, uint32_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMessageQueueGet</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>gad90d4959466a7a65105061da8256ab9e</anchor>
      <arglist>(osMessageQueueId_t mq_id, void *msg_ptr, uint8_t *msg_prio, uint32_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMessageQueueGetCapacity</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>gac24f87d4f395e9e9c900c320e45ade8a</anchor>
      <arglist>(osMessageQueueId_t mq_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMessageQueueGetMsgSize</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>ga96d3d84069b20359de48109e28a1a89e</anchor>
      <arglist>(osMessageQueueId_t mq_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMessageQueueGetCount</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>ga6a32ac394fcff568b251c160cc3014b2</anchor>
      <arglist>(osMessageQueueId_t mq_id)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osMessageQueueGetSpace</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>gaddf0904427436dd3880d46263c2dc9fa</anchor>
      <arglist>(osMessageQueueId_t mq_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMessageQueueReset</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>gac6dce7f9ad132d266292c2e979d861b4</anchor>
      <arglist>(osMessageQueueId_t mq_id)</arglist>
    </member>
    <member kind="function">
      <type>osStatus_t</type>
      <name>osMessageQueueDelete</name>
      <anchorfile>group__CMSIS__RTOS__Message.html</anchorfile>
      <anchor>gaba987f665444e0d83fa6a3a68bc72abe</anchor>
      <arglist>(osMessageQueueId_t mq_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_Definitions</name>
    <title>Generic Definitions</title>
    <filename>group__CMSIS__RTOS__Definitions.html</filename>
    <subgroup>flags_error_codes</subgroup>
    <member kind="define">
      <type>#define</type>
      <name>osWaitForever</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>ga9eb9a7a797a42e4b55eb171ecc609ddb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsWaitAny</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>ga18e63587b8450d5b8798b6f6ec04e012</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsWaitAll</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>ga8b6f562736fbfb5428940e0c017dec24</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsNoClear</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gaade844a42237d8c37569d4d9b16b9f1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osSafetyClass</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>ga604fce4f5205f92c347eb62fcc216861</anchor>
      <arglist>(n)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osSafetyWithSameClass</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>ga7abd2d95425d9e02672778b3464b2eaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osSafetyWithLowerClass</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>ga8c77ee126b9215425fc004ee13cdc6de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>osStatus_t</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>ga6c0dbe6069e4e7f47bb4cd32ae2b813e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osOK</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813eab17c65ad8b5bae759882b41c5bf35cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osError</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813eacb77fd6a5f0f177b06847a629f6054e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osErrorTimeout</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813ea809f56df47a0269cdd4501e0d03eb603</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osErrorResource</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813ea75ed7d9f50a54adb727f61486ff2cc02</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osErrorParameter</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813ea146cdcbc5c2b6f43e196294dbc59e12c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osErrorNoMemory</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813ea1bccee013c5725778b750a54c4f9e57d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osErrorISR</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813ea91c2ea9c9cd03401ff7d396c636d1864</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osErrorSafetyClass</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813ea7379a8ce2e513723390bb01d2efeb981</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>osStatusReserved</name>
      <anchorfile>group__CMSIS__RTOS__Definitions.html</anchorfile>
      <anchor>gga6c0dbe6069e4e7f47bb4cd32ae2b813ea59d1c52ddb4ba7a7738039756e79d982</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>flags_error_codes</name>
    <title>Flags Functions Error Codes</title>
    <filename>group__flags__error__codes.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsErrorUnknown</name>
      <anchorfile>group__flags__error__codes.html</anchorfile>
      <anchor>ga3b1d9fbb83d64eedb62f831c9be647c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsErrorTimeout</name>
      <anchorfile>group__flags__error__codes.html</anchorfile>
      <anchor>ga2e951c3f1c3b7bff4eca3d7836cd19ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsErrorResource</name>
      <anchorfile>group__flags__error__codes.html</anchorfile>
      <anchor>ga4db38b50da1889bcaaa7f747e844f904</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsErrorParameter</name>
      <anchorfile>group__flags__error__codes.html</anchorfile>
      <anchor>gaa8a95ef938f8f5a9fcb815ec53184f77</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>osFlagsErrorISR</name>
      <anchorfile>group__flags__error__codes.html</anchorfile>
      <anchor>gaea3abd186643f539877e894b62b63448</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>CMSIS_RTOS_TickAPI</name>
    <title>OS Tick API</title>
    <filename>group__CMSIS__RTOS__TickAPI.html</filename>
    <member kind="function">
      <type>int32_t</type>
      <name>OS_Tick_Setup</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>ga5eeffb4d9dc6c6802fee8898096d9a59</anchor>
      <arglist>(uint32_t freq, IRQHandler_t handler)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>OS_Tick_Enable</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>gaaa0d6ddef6816e8e5650fde3daf191e7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>OS_Tick_Disable</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>ga50fc040b66fabd1945d2bd1d0d05661d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>OS_Tick_AcknowledgeIRQ</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>ga14c430d2b363ebd9f904b0822a9314e7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>OS_Tick_GetIRQn</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>gaa8b4eca23e3ffe2df403291958cdc905</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>OS_Tick_GetClock</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>ga936217ea28236fb57648973e0d8f627a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>OS_Tick_GetInterval</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>ga123151dc19d5a94a68f12cdbf61a9bb5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>OS_Tick_GetCount</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>gaa64a145a554f1e5077848938d7f39c92</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>OS_Tick_GetOverflow</name>
      <anchorfile>group__CMSIS__RTOS__TickAPI.html</anchorfile>
      <anchor>ga1f9a593126b7f0b66fc526c2cebd6192</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>rtos_revisionHistory</name>
    <title>Revision History</title>
    <filename>rtos_revisionHistory.html</filename>
    <docanchor file="rtos_revisionHistory.html">md_src_history</docanchor>
  </compound>
  <compound kind="page">
    <name>usingOS2</name>
    <title>Using CMSIS-RTOS2 Interface</title>
    <filename>usingOS2.html</filename>
    <docanchor file="usingOS2.html">md_src_using</docanchor>
    <docanchor file="usingOS2.html" title="Functionality overview">rtos2_functionalities</docanchor>
    <docanchor file="usingOS2.html" title="cmsis_os2.h API header file">cmsis_os2_h</docanchor>
    <docanchor file="usingOS2.html" title="Coding Rules">cmsis_os2_coding_rules</docanchor>
    <docanchor file="usingOS2.html" title="System Startup">SystemStartup</docanchor>
    <docanchor file="usingOS2.html" title="Lifecycle of RTOS Objects">rtos_objects</docanchor>
    <docanchor file="usingOS2.html" title="Create Objects">rtos_objects_create</docanchor>
    <docanchor file="usingOS2.html" title="Object Usage">rtos_objects_usage</docanchor>
    <docanchor file="usingOS2.html" title="Object Destruction">rtos_objects_delete</docanchor>
    <docanchor file="usingOS2.html" title="Timeout Values">CMSIS_RTOS_TimeOutValue</docanchor>
    <docanchor file="usingOS2.html" title="Calls from Interrupt Service Routines">CMSIS_RTOS_ISR_Calls</docanchor>
    <docanchor file="usingOS2.html" title="Memory Management">CMSIS_RTOS_MemoryMgmt</docanchor>
    <docanchor file="usingOS2.html" title="Automatic Dynamic Allocation">CMSIS_RTOS_MemoryMgmt_Automatic</docanchor>
    <docanchor file="usingOS2.html" title="Manual User-defined Allocation">CMSIS_RTOS_MemoryMgmt_Manual</docanchor>
  </compound>
  <compound kind="page">
    <name>CMSIS_RTOS_ProcessIsolation</name>
    <title>Process Isolation</title>
    <filename>CMSIS_RTOS_ProcessIsolation.html</filename>
    <docanchor file="CMSIS_RTOS_ProcessIsolation.html">md_src_processIsolation</docanchor>
  </compound>
  <compound kind="page">
    <name>rtos_process_isolation_mpu</name>
    <title>MPU Protected Zones</title>
    <filename>rtos_process_isolation_mpu.html</filename>
    <docanchor file="rtos_process_isolation_mpu.html" title="Define MPU Protected Zones">rtos_process_isolation_mpu_def</docanchor>
    <docanchor file="rtos_process_isolation_mpu.html" title="Load MPU Protected Zone">rtos_process_isolation_mpu_load</docanchor>
    <docanchor file="rtos_process_isolation_mpu.html" title="RTOS Objects and MPU Protection">rtos_process_isolation_mpu_objects</docanchor>
    <docanchor file="rtos_process_isolation_mpu.html" title="Handle Memory Access Faults">rtos_process_isolation_mpu_fault</docanchor>
  </compound>
  <compound kind="page">
    <name>rtos_process_isolation_safety_class</name>
    <title>Safety Classes</title>
    <filename>rtos_process_isolation_safety_class.html</filename>
    <docanchor file="rtos_process_isolation_safety_class.html" title="Assign Safety Class to an RTOS Object">rtos_process_isolation_safety_class_assign</docanchor>
    <docanchor file="rtos_process_isolation_safety_class.html" title="Handle Object Access Violation">rtos_process_isolation_safety_class_error</docanchor>
  </compound>
  <compound kind="page">
    <name>rtos_process_isolation_thread_wdt</name>
    <title>Thread Watchdogs</title>
    <filename>rtos_process_isolation_thread_wdt.html</filename>
  </compound>
  <compound kind="page">
    <name>rtos_process_isolation_faults</name>
    <title>Fault Handling</title>
    <filename>rtos_process_isolation_faults.html</filename>
  </compound>
  <compound kind="page">
    <name>rtosValidation</name>
    <title>RTOS Validation</title>
    <filename>rtosValidation.html</filename>
    <docanchor file="rtosValidation.html">md_src_validation</docanchor>
  </compound>
  <compound kind="page">
    <name>index</name>
    <title>Overview</title>
    <filename>index.html</filename>
    <docanchor file="index.html">mainpage</docanchor>
    <docanchor file="index.html" title="Benefits">rtos2_benefits</docanchor>
    <docanchor file="index.html" title="Supported RTOS kernels">rtos2_kernels</docanchor>
    <docanchor file="index.html" title="Access to CMSIS-RTOS2">rtos2_access</docanchor>
  </compound>
</tagfile>
