# M451 Series CMSIS BSP

This BSP folder

## .\Document\


- Revision History.pdf<br>
	Show all the revision history about specific BSP.

- CMSIS.html<br>
	Describe all of the information of CMSIS library, including CMSIS-CORE, CMSIS-DSP, CMSIS-RTOS API and CMSIS-SVD.

- NuMicro M451 Series Driver Reference Guide.chm<br>
	Describe the definition, input and output of each API.

## .\Library\


- CMSIS<br>
	CMSIS definitions by ARM® Corp.

- Device<br>
	CMSIS compliant device header file.

- StdDriver<br>
	All peripheral driver header and source files.

- SmartcardLib<br>
	Library for CCID smart card reader.

- UsbHostLib<br>
	Library for USB Host.

- NuEdu<br>
	Library for NuEdu board.

## .\Sample Code\


- CardReader<br>
	CCID smart card reader sample code.

- CortexM4<br>
	Cortex®-M4 sample code.

- FreeRTOS<br>
	Simple FreeRTOS™ demo code.

- Hard\_Fault\_Sample<br>
	Show hard fault information when hard fault happened.

- ISP<br>
	Sample codes for In-System-Programming.

- Nu-LB-M451<br>
	Sample codes for M451 learning board.

- NuTiny-SDK-M451<br>
	Sample codes for M451 Tiny Board.

- Template<br>
	Software Development Template.

- Semihost<br>
	Show how to debug with semi-host message print.

- RegBased<br>
	The sample code about to access control registers directly.

- NuEdu<br>
	Sample code for M451 NuEdu Evaluation Board.

- StdDriver<br>
	M451 Series Driver Sample.

## .\ThirdParty\


- FatFs<br>
	An open source FAT/exFAT filesystem library.

- FreeRTOS<br>
	FreeRTOS porting for M451.


# Licesne

**SPDX-License-Identifier: Apache-2.0**

Copyright in some of the content available in this BSP belongs to third parties.
Third parties license is specified in a file header or license file.
M451 BSP files are provided under the Apache-2.0 license.

