/*---------------------------------------------------------------------------------------------------------*/
/*                                                                                                         */
/* Copyright(c) 2020 Nuvoton Technology Corp. All rights reserved.                                         */
/*                                                                                                         */
/*---------------------------------------------------------------------------------------------------------*/

/***********************************************************************************************************/
/* Website: http://www.nuvoton.com                                                                         */
/*  E-Mail : MicroC-8bit@nuvoton.com                                                                       */
/*  Date   : Apr/29/2020                                                                                   */
/***********************************************************************************************************/

/************************************************************************************************************/
/*  File Function: ML51 Wakeup timer demo code with interrupt                                               */
/************************************************************************************************************/

#include "ML51.h"


void WakeUp_Timer_ISR (void)   interrupt 17     //ISR for self wake-up timer
{

    _push_(SFRS);
      P32 = ~P32;
      clr_WKCON_WKTF;                                   //clear interrupt flag
    _pop_(SFRS);
}


/************************************************************************************************************
*    Main function 
************************************************************************************************************/
void main (void)
{
   
    P32_PUSHPULL_MODE;

//-----------------------------------------------------
//  WKT initial   
//-----------------------------------------------------  
    WKT_Open (LIRC,4,96);            // 96*4/38400 = 10ms
    WKT_Interrupt(Enable);             // enable WKT interrupt
    ENABLE_GLOBAL_INTERRUPT;

    while(1);

}

