/***************************************************************************//**
 * @file     uart_transfer.c
 * @brief    General UART ISP slave Sample file
 * @version  2.0.0
 *
 * @copyright (C) 2019 Nuvoton Technology Corp. All rights reserved.
 ******************************************************************************/

/*!<Includes */
#include <string.h>
#include "targetdev.h"

uint8_t uart_rcvbuf[MAX_PKT_SIZE] __attribute__((aligned (4))) = {0};

uint8_t volatile bUartDataReady = 0;
uint8_t volatile bufhead = 0;


/* please check "targetdev.h" for chip specifc define option */

/*---------------------------------------------------------------------------------------------------------*/
/* ISR to handle UART Channel 0 interrupt event                                                            */
/*---------------------------------------------------------------------------------------------------------*/
void UART0_IRQHandler(void)
{
    /*----- Determine interrupt source -----*/
    /* Offset: 0x1C  UART Interrupt Status Register                                     */
    uint32_t u32IntSrc = UART0->INTSTS;

    // UART_INTSTS_RDAIF_Msk && UART_INTSTS_RXTOIF_Msk
    if (u32IntSrc & 0x11)   //RDA FIFO interrupt & RDA timeout interrupt
    {
        while (((UART0->FIFOSTS & UART_FIFOSTS_RXEMPTY_Msk) == 0) && (bufhead < MAX_PKT_SIZE))      //RX fifo not empty
        {
            uart_rcvbuf[bufhead++] = UART0->DAT;
        }
    }

    if (bufhead == MAX_PKT_SIZE)
    {
        bUartDataReady = TRUE;
        bufhead = 0;
    }
    else if (u32IntSrc & 0x10)
    {
        bufhead = 0;
    }
}

extern uint8_t response_buff[64] __attribute__((aligned (4)));
void PutString(void)
{
    uint32_t i;

    for (i = 0; i < MAX_PKT_SIZE; i++)
    {
        while ((UART0->FIFOSTS & UART_FIFOSTS_TXFULL_Msk));

        UART0->DAT = response_buff[i];
    }
}

void UART_Init()
{
    /*---------------------------------------------------------------------------------------------------------*/
    /* Init UART                                                                                               */
    /*---------------------------------------------------------------------------------------------------------*/
    UART0->CTRL &= ~(UART_CTRL_RXOFF_Msk | UART_CTRL_TXOFF_Msk);
    UART0->FUNCSEL = UART_FUNCSEL_UART;
    UART0->LINE = UART_WORD_LEN_8 | UART_PARITY_NONE | UART_STOP_BIT_1 |
                  UART_LINE_RFITL_14BYTES | UART_LINE_RTS_TRI_LEV_14BYTES;
    UART0->BAUD = (UART_BAUD_MODE0 | UART_BAUD_MODE0_DIVIDER(__MIRC, 115200));
    UART0->TOUT = 0x40;
    UART0->INTEN = (UART_INTEN_RDAIEN_Msk | UART_INTEN_RXTOIEN_Msk);
    NVIC_SetPriority(UART0_IRQn, 2);
    NVIC_EnableIRQ(UART0_IRQn);
}
