/***************************************************************************//**
 * @file     targetdev.c
 * @brief    ISP support function source file
 *
 * @note
 * Copyright (C) 2019 Nuvoton Technology Corp. All rights reserved.
 ******************************************************************************/
#include "targetdev.h"
#include "fmc_user.h"

//the smallest of APROM size is 32K (32K, 64K, 123K)
uint32_t GetApromSize()
{
    uint32_t size = 0x8000, data;
    int result;

    do
    {
        result = FMC_Read_User(size, &data);

        if (result < 0)
        {
            if (size == 0x20000)
            {
                size = 123 * 1024;
            }

            return size;
        }
        else
        {
            size *= 2;
        }
    } while (1);
}

void GetDataFlashInfo(uint32_t *addr, uint32_t *size)
{
    uint32_t uData;
    *size = 0;
    FMC_Read_User(FMC_CONFIG_BASE, &uData);
    uData &= 0x000FFFFF;

    if ((uData & 0x01) == 0)   //DFEN enable
    {
        FMC_Read_User(FMC_CONFIG_BASE + 4, &uData);

        // filter the reserved bits in CONFIG1
        uData &= 0x000FFFFF;

        if (uData > g_apromSize || uData & 0x1FF)   //avoid config1 value from error
        {
            uData = g_apromSize;
        }

        *addr = uData;
        *size = g_apromSize - uData;
    }
    else
    {
        *addr = g_apromSize;
        *size = 0;
    }
}

