# Introduction

The **CMSIS** (Common Microcontroller Software Interface Standard) is a set of APIs, software components, tools, and workflows that help to simplify software re-use, reduce the learning curve for microcontroller developers, speed-up project build and debug, and thus reduce the time to market for new applications.

## CMSIS Components

![CMSIS Components Overview](./images/cmsis_components.png)

## CMSIS v6 Introduction Webinar

Watch the [introduction webinar](https://on-demand.arm.com/flow/arm/devhub/sessionCatalog/page/pubSessCatalog/session/1705915235972001vEdN) to learn about CMSIS v6 amd how to use it.

[![CMSIS v6 Introduction Webinar](./images/cmsis6introwebinar.png)](https://on-demand.arm.com/flow/arm/devhub/sessionCatalog/page/pubSessCatalog/session/1705915235972001vEdN)

## Related CMSIS-Packs

The following CMSIS-Packs relate to CMSIS v6 and are maintained by Arm.

### CMSIS Component Packs

- [CMSIS-Compiler](https://www.keil.arm.com/packs/cmsis-compiler-arm): Retarget I/O functions of the standard C run-time library.
- [CMSIS-DSP](https://www.keil.arm.com/packs/cmsis-dsp-arm/): Optimized compute functions for embedded systems.
- [CMSIS-NN](https://www.keil.arm.com/packs/cmsis-nn-arm): Efficient and performant neural network kernels.
- [CMSIS-View](https://www.keil.arm.com/packs/cmsis-view-arm): Event Recorder and Component Viewer technology.

### Real-time Operating Systems

- [CMSIS-RTX](https://www.keil.arm.com/packs/cmsis-rtx-arm): Keil RTX5, a CMSIS-RTOS2 API compliant real-time operating system.
- [CMSIS-FreeRTOS](https://github.com/ARM-software/CMSIS-FreeRTOS): CMSIS-RTOS adaptation of FreeRTOS.
- [CMSIS-RTOS2 Validation](https://github.com/arm-software/CMSIS-RTOS2_Validation): Validation suite for RTOS2 compliant implementations.

### Middleware

- [MDK-Middleware](https://www.keil.arm.com/packs/mdk-middleware-keil): File system, network, and USB stacks.
- [CMSIS-mbedTLS](https://github.com/ARM-software/CMSIS-mbedTLS): Mbed TLS framed in a CMSIS-Pack.
- [SDS-Framework](https://github.com/ARM-software/SDS-Framework): Synchronous data streaming.

### Other Software Components

- [Cortex_DFP](https://github.com/ARM-software/CMSIS-DFP): Generic Arm Cortex-M device family pack.
- [CMSIS-Driver](https://github.com/ARM-software/CMSIS-Driver): MCU peripheral driver implementations.
- [CMSIS-Driver Validation](https://github.com/ARM-software/CMSIS-Driver_Validation/): Validation suite for CMSIS-Driver implementations.
