/**************************************************************************//**
 * @file     w99683.h
 * @brief    W99683 USB device driver header file
 *
 * SPDX-License-Identifier: Apache-2.0
 * @copyright (C) 2020 Nuvoton Technology Corp. All rights reserved.
*****************************************************************************/
#define W99683_VENDOR_ID      0x0416
#define W99683_PRODUCT_ID     0x9683
//#define W99683_PRODUCT_ID     0x6830


/* General Control Register */
#define MiscCAR                 0x0000
/*
 * Engine sequence 7  Memory Controller
 *                 6  USB Interface
 *                 5  Flash Memory Interface
 *                 4  Display Controller
 *                 3  JPEG CODEC
 *                 2  Audio Interface
 *                 1  Video Processing Engine
 *                 0  DSP
 */
#define EngResetCR              0x0002 // 0:normal , 1:reset
#define EngClockCR              0x0003 // Clock Enable
#define EngOPCR                 0x0004 // Operation Enable
#define GINTCR                  0x0005 // interrupt Enable
#define GINTSR                  0x0006 // interrupt Generated
#define SerialBusCR             0x0007 
// bit5:SIE, bit4:SDA, bit3:SCK, bit2:SIE pin, bit1:SDA pin, bit0:SCK pin
#define GPIOLoR                 0x0008 // GPIO[7:0]  0:out , 1:in
#define GPIOHiR                 0x000d // GPIO[15:8] 0:out , 1:in
#define GPIODataLoR             0x0009 // GPIO[7:0]
#define GPIODataHiR             0x000e // GPIO[15:8]
#define GPIOAR                  0x0012
#define GPIOADataR              0x0013
#define GPIOBR                  0x0014
#define GPIOBDataR              0x0015

/* SDRAM Control Register */
#define DualBufferCR            0x0050 

/* Sensor DSP Control Register */
#define CropStartXLoR           0x011c // [7:0]
#define CropStartXHiR           0x011d // [11:8]
#define CropStartYLoR           0x011e // [7:0]
#define CropStartYHiR           0x011f // [11:8]
#define CropWidthLoR            0x0120 // [7:0]
#define CropWidthHiR            0x0121 // [11:8]
#define CropHeightLoR           0x0122 // [7:0]
#define CropHeightHiR           0x0123 // [11:8]

// Video Processing Engine Control Register
#define CapC1R                  0x0200 
#define CapC2R                  0x0201 
#define CapY0StartLoR           0x0202 // [7:0] word unit
#define CapY0StartMiR           0x0203 // [15:8]
#define CapY0StartHiR           0x0204 // [22:16]
#define CapU0StartLoR           0x0205 
#define CapU0StartMiR           0x0206
#define CapU0StartHiR           0x0207
#define CapV0StartLoR           0x0208
#define CapV0StartMiR           0x0209
#define CapV0StartHiR           0x020a
#define CapY1StartLoR           0x020e
#define CapY1StartMiR           0x020f
#define CapY1StartHiR           0x0210
#define CapU1StartLoR           0x0211
#define CapU1StartMiR           0x0212
#define CapU1StartHiR           0x0213
#define CapV1StartLoR           0x0214
#define CapV1StartMiR           0x0215
#define CapV1StartHiR           0x0216
#define CapYOffsetLoR           0x021a // [7:0]  non-use data per line
#define CapYOffsetHiR           0x021b // [10:8]
#define CapUVOffsetLoR          0x021c // [7:0]  
#define CapUVOffsetHiR          0x021d // [10:8]  
#define CapHoriScaleMR          0x0220 // N/M
#define CapHoriScaleNR          0x0221
#define CapVertScaleMR          0x0222 // N/M
#define CapVertScaleNR          0x0223

// JPEG Codec Control Register
#define JPGSelectCR             0x0280 
#define JPGHeaderCR             0x0281 // 0:not 1:include
#define JPGUpScaleCR            0x0282 
#define JPGRSizeLoR             0x0283 // reserved size
#define JPGRSizeHiR             0x0284
#define JPGDnScaleCR            0x0287
// bit7:Enable, bit6~bit4:H=2*(1+XXX), bit3~bit0:V=1+XXXX
#define JPGHeightLoR            0x028b
#define JPGHeightHiR            0x028c
#define JPGWidthLoR             0x028d
#define JPGWidthHiR             0x028e
#define JPGRSTLoR               0x0293 
#define JPGRSTHiR               0x0294
#define JPGFrameStrideLoR       0x0297 // words line-to-line
#define JPGFrameStrideMiR       0x0298
#define JPGFrameStrideHiR       0x0299
#define JPGY0StartLoR           0x029a // [7:0] word unit
#define JPGY0StartMiR           0x029b // [15:8]
#define JPGY0StartHiR           0x029c // [22:16]
#define JPGU0StartLoR           0x029d
#define JPGU0StartMiR           0x029e
#define JPGU0StartHiR           0x029f
#define JPGV0StartLoR           0x02a0
#define JPGV0StartMiR           0x02a1
#define JPGV0StartHiR           0x02a2
#define JPGY1StartLoR           0x02a3
#define JPGY1StartMiR           0x02a4
#define JPGY1StartHiR           0x02a5
#define JPGU1StartLoR           0x02a6
#define JPGU1StartMiR           0x02a7
#define JPGU1StartHiR           0x02a8
#define JPGV1StartLoR           0x02a9
#define JPGV1StartMiR           0x02aa
#define JPGV1StartHiR           0x02ab
#define JPGYStideLoR            0x02ac // [7:0] word unit
#define JPGYStideHiR            0x02ad // [15:8]
#define JPGUStideLoR            0x02ae
#define JPGUStideHiR            0x02af
#define JPGVStideLoR            0x02b0
#define JPGVStideHiR            0x02b1
#define JPGStrm0StartLoR        0x02b2 // [7:0] word unit
#define JPGStrm0StartMiR        0x02b3 // [15:8] 
#define JPGStrm0StartHiR        0x02b4 // [22:16]
#define JPGStrm1StartLoR        0x02b5
#define JPGStrm1StartMiR        0x02b6
#define JPGStrm1StartHiR        0x02b7
#define JPGINTCSR               0x02b8
#define JPGENCSIZELoR           0x02bd
#define JPGENCSIZEMiR           0x02be
#define JPGENCSIZEHiR           0x02bf

#define LumQTable               0x0300
#define ChrQTable               0x0340

// USB Interface Control Register
#define UsbVISOCR               0x060e 
#define UsbVISOStartLoR         0x0650 // [7:0] word unit
#define UsbVISOStartMiR         0x0651 // [15:8]
#define UsbVISOStartHiR         0x0652 // [22:16]
#define UsbVISOSizeLoR          0x0653 
#define UsbVISOSizeMiR          0x0654  
#define UsbVISOSizeHiR          0x0655 
#define UsbISOOPCR              0x0658

//
// W99683 Vendor Requests
//

#define W99683_RegisterReadRequest     0x00
#define W99683_RegisterWriteRequest    0x01
#define W99683_I2CReadRequest          0x02
#define W99683_I2CWriteRequest         0x03

//      
// Video Capture Control State definitions
//
//
// MiscCAR ( CR0000 )
// AND =
#define PINS                    0x08 // 0: 128, 1:208
#define uC                      0x04 // 0: External 1:internal
#define SDRAM_SIZE              0x03 // 0:00-16MB,01-4MB,10-8MB,11-2MB
#define SDRAM_16MB              0x00
#define SDRAM_4MB               0x01
#define SDRAM_8MB               0x02
#define SDRAM_2MB               0x03

// EngResetCR ( CR0002 )
// OR
#define DSP_RESET               0x01
#define VPRE_RESET              0x02
//#define AUDIO_RESET             0x04  /* SW remove due to confilct with N9H20 */
#define JPEG_RESET              0x08
#define DISPLAY_RESET           0x10
#define FLASH_RESET             0x20
#define USB_RESET               0x40
#define MEMORY_RESET            0x80
// AND
#define DSP_NORMAL              0xfe
#define VPRE_NORMAL             0xfd
#define AUDIO_NORMAL            0xfb
#define JPEG_NORMAL             0xf7
#define DISPLAY_NORMAL          0xef
#define FLASH_NORMAL            0xdf
#define USB_NORMAL              0xbf
#define MEM_NORMAL              0x7f
#define ALL_NORMAL              0x00

// EngClockCR ( CR0003 )
// OR
#define ALL_CLOCK               0xff

// EngOPCR ( CR0004 )
// OR
#define DSP_ENABLE              0x01
#define VPRE_ENABLE             0x02
#define AUDIO_ENABLE            0x04
#define JPEG_ENABLE             0x08
#define DISPLAY_ENABLE          0x10
#define FLASH_ENABLE            0x20
#define USB_ENABLE              0x40
#define MEM_ENABLE              0x80
// AND
#define DSP_DISABLE             0xfe
#define VPRE_DISABLE            0xfd
#define AUDIO_DISABLE           0xfb
#define JPEG_DISABLE            0xf7
#define DISPLAY_DISABLE         0xef
#define FLASH_DISABLE           0xdf
#define USB_DISABLE             0xbf
#define MEM_DISABLE             0x7f

// GINTCR ( CR0005 )
// OR 
// xxx_ENABLE the same with CR0004
// AND
// xxx_DISABLE the same with CR0004

// SerialBusCR ( CR0007 )
// AND
#define I2C_CLEAR               0xF8

// DualBufferCR ( CR0050 )
// OR
#define DB_ENABLE               0x80
#define SWDB_ENABLE             0x40
// AND
#define SWDB_DISBALE            0xbf
#define DB_CLEAR                0x00

// CapC1R ( CR0200 )
// AND =
#define VPRE_PLANE              0x20
#define VPRE_PACKET             0x40
#define VPRE_TVDECODE           0x04
#define VPRE_YUV                0x08

// = 
#define VPRE_CAPTURE_TVDECODE_PLANE     0x3c
#define VPRE_CAPTURE_TVDECODE_PACKET    0x54
#define VPRE_CAPTURE_TVDECODE_RGB       0x74
#define VPRE_CAPTURE_SENSOR_PLANE       0x38
#define VPRE_CAPTURE_SENSOR_PACKET      0x50
#define VPRE_CAPTURE_SENSOR_RGB         0x70

// CapC2R ( CR0201 )
// OR
#define CAPTURE_420             0x10
#define CAPTURE_422             0x08
// AND
#define CAPTURE_DISABLE_420     0xEF
#define CAPTURE_DISABLE_422     0xF7

// JPGSelectCR ( CR0280 )
// OR
#define ENCODE_420              0x90
#define ENCODE_422              0x94
#define ENCODE_DB               0x20
#define ENCODE_CONTINUE         0x40
// AND
#define ENCODE_DISABLE_420      0xFF   
#define ENCODE_DISABLE_422      0xFB

// JPGHeaderCR ( CR0281 )
// OR
#define INCLUDE_JFIF            0x80
#define INCLUDE_HUF             0x40
#define INCLUDE_Q               0x20
#define INCLUDE_RST             0x10
// AND
#define NOT_INCLUDE_ALL         0x0f
#define NOT_INCLUDE_THUMB_ALL   0xf0

// JPGUpScaleCR ( CR0282 )
// OR
#define JPEG_HX2                0xa0
#define JPEG_VX2                0x50
#define JPEG_VX12               0x18
// AND
#define JPEG_UP_CLEAR           0x07

// JPGDnScaleCR ( CR0287 )
// OR
#define JPEG_DN_ENABLE          0x80
#define JPEG_HD2                0x00
#define JPEG_HD4                0x10
#define JPEG_VD1                0x00
#define JPEG_VD2                0x01
#define JPEG_VD4                0x03
// AND
#define JPEG_DN_CLEAR           0x00

// JPGINTCSR ( CR02B8 )
// OR
#define JPGINT_ENCODE_CLEAR     0x08
#define JPGINT_DECODE_CLEAR     0x04
#define JPGINT_ERROR_CLEAR      0x02
// AND
#define JPGINT_ENCODE_DISABLE   0x7f
#define JPGINT_DECODE_DISABLE   0xbf
#define JPGINT_ERROR_DISABLE    0xef

// AND =
#define JPGINT_ENCODE_GET       0x80
#define JPGINT_DECODE_GET       0x40
#define JPGINT_ERROR_GET        0x20

// UsbVISOCR ( CR060E )
// OR
#define VISO_ENABLE             0xa0 
// AND
#define VISO_DISABLE            0x5f

// UsbVISOSizeLoR ( CR0653 ~ CR0655 )
#define CONTINUOUT_MODE_SIZE_LO 0xff
#define CONTINUOUT_MODE_SIZE_MI 0xff
#define CONTINUOUT_MODE_SIZE_HI 0x7f

// UsbISOOPCR ( CR0658 )
#define VISO_CONTINUOUS         0x01
#define VISO_EXTRA              0x02
// AND
#define VISO_NON_CONTINUOUS     0xfe
#define VISO_NON_EXTRA          0xfd



/*
 *  defined for I2C
 */
#define SA7111_WRITE         0x48
#define SA7111_READ          0x49
#define HP2020_WRITE         0xaa
#define HP2020_READ          0xab
#define OV7620_WRITE         0x42
#define OV7620_READ          0x43
#define OV8610_WRITE         0xa0
#define OV8610_READ          0xa1
#define M20027_WRITE         0x66
#define M20027_READ          0x67


#define RevZigzag(i)       Revizigzag_index[i]

int Revizigzag_index[] =
{ 0, 1, 5, 6,14,15,27,28,
  2, 4, 7,13,16,26,29,42,
  3, 8,12,17,25,30,41,43,
  9,11,18,24,31,40,44,53,
 10,19,23,32,39,45,52,54,
 20,22,33,38,46,51,55,60,
 21,34,37,47,50,56,59,61,
 35,36,48,49,57,58,62,63};


int quantSel;
int quantPos;

unsigned char InitQuantizationTable[][138] =
{

// Selection 0
{               // Y,UV:Default Q
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x10,
0x0b,
0x0c,
0x0e,
0x0c,
0x0a,
0x10,
0x0e,
0x0d,
0x0e,
0x12,
0x11,
0x10,
0x13,
0x18,
0x28,
0x1a,
0x18,
0x16,
0x16,
0x18,
0x31,
0x23,
0x25,
0x1d,
0x28,
0x3a,
0x33,
0x3d,
0x3c,
0x39,
0x33,
0x38,
0x37,
0x40,
0x48,
0x5c,
0x4e,
0x40,
0x44,
0x57,
0x45,
0x37,
0x38,
0x50,
0x6d,
0x51,
0x57,
0x5f,
0x62,
0x67,
0x68,
0x67,
0x3e,
0x4d,
0x71,
0x79,
0x70,
0x64,
0x78,
0x5c,
0x65,
0x67,
0x63,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x11,
0x12,
0x12,
0x18,
0x15,
0x18,
0x2f,
0x1a,
0x1a,
0x2f,
0x63,
0x42,
0x38,
0x42,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
},
// Selection 1
{                               //Y:Default Q/2 UV:Default Q/2
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x08,
0x06,
0x06,
0x07,
0x06,
0x05,
0x08,
0x07,
0x07,
0x07,
0x09,
0x09,
0x08,
0x0a,
0x0c,
0x14,
0x0d,
0x0c,
0x0b,
0x0b,
0x0c,
0x19,
0x12,
0x13,
0x0f,
0x14,
0x1d,
0x1a,
0x1f,
0x1e,
0x1d,
0x1a,
0x1c,
0x1c,
0x20,
0x24,
0x2e,
0x27,
0x20,
0x22,
0x2c,
0x23,
0x1c,
0x1c,
0x28,
0x37,
0x29,
0x2c,
0x30,
0x31,
0x34,
0x34,
0x34,
0x1f,
0x27,
0x39,
0x3d,
0x38,
0x32,
0x3c,
0x2e,
0x33,
0x34,
0x32,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x09,
0x09,
0x09,
0x0c,
0x0b,
0x0c,
0x18,
0x0d,
0x0d,
0x18,
0x32,
0x21,
0x1c,
0x21,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
},

// Selection 2
{               // Y:Default 2.5Q, UV:Default 2.5Q
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x06,
0x05,
0x05,
0x06,
0x05,
0x05,
0x07,
0x06,
0x06,
0x06,
0x08,
0x08,
0x07,
0x08,
0x0a,
0x11,
0x0b,
0x0a,
0x0a,
0x0a,
0x0a,
0x15,
0x0f,
0x10,
0x0d,
0x11,
0x19,
0x16,
0x19,
0x19,
0x18,
0x16,
0x18,
0x17,
0x1b,
0x24,
0x27,
0x21,
0x1b,
0x1d,
0x25,
0x1d,
0x17,
0x18,
0x22,
0x2e,
0x22,
0x25,
0x28,
0x29,
0x2b,
0x2c,
0x2b,
0x1a,
0x21,
0x30,
0x33,
0x2e,
0x2a,
0x32,
0x27,
0x2b,
0x2b,
0x2a,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x08,
0x08,
0x08,
0x0a,
0x09,
0x0a,
0x14,
0x11,
0x11,
0x14,
0x2a,
0x1c,
0x18,
0x1c,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
0x2a,
},

// Selection 3
{               //Y: Default Q/3, UV:Default Q/3
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x06,
0x04,
0x04,
0x05,
0x04,
0x04,
0x06,
0x05,
0x05,
0x05,
0x06,
0x06,
0x06,
0x07,
0x08,
0x0e,
0x09,
0x08,
0x08,
0x08,
0x08,
0x11,
0x0c,
0x0d,
0x0a,
0x0e,
0x14,
0x11,
0x15,
0x14,
0x13,
0x11,
0x13,
0x13,
0x16,
0x18,
0x1f,
0x1a,
0x16,
0x17,
0x1d,
0x17,
0x13,
0x13,
0x1b,
0x25,
0x1b,
0x1d,
0x20,
0x21,
0x23,
0x23,
0x23,
0x15,
0x1a,
0x26,
0x29,
0x26,
0x22,
0x28,
0x1f,
0x22,
0x23,
0x21,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x06,
0x06,
0x06,
0x08,
0x07,
0x08,
0x10,
0x09,
0x09,
0x10,
0x21,
0x16,
0x13,
0x16,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
},

// Selection 4
{                       // Y:Default Q/4, UV: Default Q/4
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x04,
0x03,
0x03,
0x04,
0x03,
0x03,
0x04,
0x04,
0x04,
0x04,
0x05,
0x05,
0x04,
0x05,
0x06,
0x0a,
0x07,
0x06,
0x06,
0x06,
0x06,
0x0d,
0x09,
0x0a,
0x08,
0x0a,
0x0e,
0x0d,
0x10,
0x0f,
0x0f,
0x0d,
0x0e,
0x0e,
0x10,
0x12,
0x17,
0x14,
0x10,
0x11,
0x16,
0x12,
0x0e,
0x0e,
0x14,
0x1c,
0x15,
0x16,
0x18,
0x19,
0x1a,
0x1a,
0x1a,
0x10,
0x14,
0x1d,
0x1f,
0x1c,
0x19,
0x1e,
0x17,
0x1a,
0x1a,
0x19,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x05,
0x05,
0x05,
0x06,
0x06,
0x06,
0x0c,
0x07,
0x07,
0x0c,
0x19,
0x11,
0x0e,
0x11,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
},

// Selection 5
{              // Y: Default Q/4, UV: Q/3
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x08,
0x03,
0x03,
0x04,
0x03,
0x03,
0x04,
0x04,
0x04,
0x04,
0x05,
0x05,
0x04,
0x05,
0x06,
0x0a,
0x07,
0x06,
0x06,
0x06,
0x06,
0x0d,
0x09,
0x0a,
0x08,
0x0a,
0x0e,
0x0d,
0x10,
0x0f,
0x0f,
0x0d,
0x0e,
0x0e,
0x10,
0x12,
0x17,
0x14,
0x10,
0x11,
0x16,
0x12,
0x0e,
0x0e,
0x14,
0x1c,
0x15,
0x16,
0x18,
0x19,
0x1a,
0x1a,
0x1a,
0x10,
0x14,
0x1d,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x08,
0x06,
0x06,
0x08,
0x07,
0x08,
0x10,
0x09,
0x09,
0x10,
0x21,
0x16,
0x13,
0x16,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x21,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
},

// Selection 6
{               // Y:Default Q/4,UV: Q/4
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x08,
0x03,
0x03,
0x04,
0x03,
0x03,
0x04,
0x04,
0x04,
0x04,
0x05,
0x05,
0x04,
0x05,
0x06,
0x0a,
0x07,
0x06,
0x06,
0x06,
0x06,
0x0d,
0x09,
0x0a,
0x08,
0x0a,
0x0e,
0x0d,
0x10,
0x0f,
0x0f,
0x0d,
0x0e,
0x0e,
0x10,
0x12,
0x17,
0x14,
0x10,
0x11,
0x16,
0x12,
0x0e,
0x0e,
0x14,
0x1c,
0x15,
0x16,
0x18,
0x19,
0x1a,
0x1a,
0x1a,
0x10,
0x14,
0x1d,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x08,
0x05,
0x05,
0x06,
0x06,
0x06,
0x0c,
0x07,
0x07,
0x0c,
0x19,
0x11,
0x0e,
0x11,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x19,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
},

// Selection 7
{               // Y: default Q/2, UV: Q
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x08,
0x06,
0x06,
0x07,
0x06,
0x05,
0x08,
0x07,
0x07,
0x07,
0x09,
0x09,
0x08,
0x0a,
0x0c,
0x14,
0x0d,
0x0c,
0x0b,
0x0b,
0x0c,
0x19,
0x12,
0x13,
0x0f,
0x14,
0x1d,
0x1a,
0x1f,
0x1e,
0x1d,
0x1a,
0x1c,
0x1c,
0x20,
0x24,
0x2e,
0x27,
0x20,
0x22,
0x2c,
0x23,
0x1c,
0x1c,
0x28,
0x37,
0x29,
0x2c,
0x30,
0x31,
0x34,
0x34,
0x34,
0x1f,
0x27,
0x39,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x11,
0x12,
0x12,
0x18,
0x15,
0x18,
0x2f,
0x1a,
0x1a,
0x2f,
0x63,
0x42,
0x38,
0x42,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
},

// Selection 8
{               // Y: Q/3, UV: Q
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x08,
0x04,
0x04,
0x05,
0x04,
0x04,
0x06,
0x05,
0x05,
0x05,
0x06,
0x06,
0x06,
0x07,
0x08,
0x0e,
0x09,
0x08,
0x08,
0x08,
0x08,
0x11,
0x0c,
0x0d,
0x0a,
0x0e,
0x14,
0x11,
0x15,
0x14,
0x13,
0x11,
0x13,
0x13,
0x16,
0x18,
0x1f,
0x1a,
0x16,
0x17,
0x1d,
0x17,
0x13,
0x13,
0x1b,
0x25,
0x1b,
0x1d,
0x20,
0x21,
0x23,
0x23,
0x23,
0x15,
0x1a,
0x26,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x11,
0x12,
0x12,
0x18,
0x15,
0x18,
0x2f,
0x1a,
0x1a,
0x2f,
0x63,
0x42,
0x38,
0x42,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
},

// Selection 9
{               // Y: Q/4, UV: Q
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x08,
0x03,
0x03,
0x04,
0x03,
0x03,
0x04,
0x04,
0x04,
0x04,
0x05,
0x05,
0x04,
0x05,
0x06,
0x0a,
0x07,
0x06,
0x06,
0x06,
0x06,
0x0d,
0x09,
0x0a,
0x08,
0x0a,
0x0e,
0x0d,
0x10,
0x0f,
0x0f,
0x0d,
0x0e,
0x0e,
0x10,
0x12,
0x17,
0x14,
0x10,
0x11,
0x16,
0x12,
0x0e,
0x0e,
0x14,
0x1c,
0x15,
0x16,
0x18,
0x19,
0x1a,
0x1a,
0x1a,
0x10,
0x14,
0x1d,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x11,
0x12,
0x12,
0x18,
0x15,
0x18,
0x2f,
0x1a,
0x1a,
0x2f,
0x63,
0x42,
0x38,
0x42,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
},


// Selection 10
{                       // accept quality, modified from Q/2
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x08,
0x08,
0x08,
0x08,
0x08,
0x08,
0x08,
0x08,
0x08,
0x08,
0x09,
0x09,
0x08,
0x0a,
0x08,
0x14,
0x0d,
0x0c,
0x0b,
0x0b,
0x0c,
0x19,
0x12,
0x13,
0x0f,
0x14,
0x1d,
0x1a,
0x1f,
0x1e,
0x1d,
0x1a,
0x1c,
0x1c,
0x20,
0x24,
0x2e,
0x27,
0x20,
0x22,
0x2c,
0x23,
0x1c,
0x1c,
0x28,
0x37,
0x29,
0x2c,
0x30,
0x31,
0x34,
0x34,
0x34,
0x1f,
0x27,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x09,
0x09,
0x09,
0x0c,
0x0b,
0x0c,
0x18,
0x0d,
0x0d,
0x18,
0x32,
0x21,
0x1c,
0x21,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x32,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
0x7f,
},

// Selection 11         // must add 1 dummy item for driver to check 0xff byte
{                       // accept quality, modified from Q/2
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x00,  // Pq = 0, Tq = 0
0x10,
0x0b,
0x0c,
0x0e,
0x0c,
0x0a,
0x10,
0x0e,
0x0d,
0x0e,
0x12,
0x11,
0x10,
0x13,
0x18,
0x28,
0x1a,
0x18,
0x16,
0x16,
0x18,
0x31,
0x23,
0x25,
0x1d,
0x28,
0x3a,
0x33,
0x3d,
0x3c,
0x39,
0x33,
0x38,
0x37,
0x40,
0x48,
0x5c,
0x4e,
0x40,
0x44,
0x57,
0x45,
0x37,
0x38,
0x50,
0x6d,
0x51,
0x57,
0x5f,
0x62,
0x67,
0x68,
0x67,
0x3e,
0x4d,
0x71,
0x79,
0x70,
0x64,
0x78,
0x5c,
0x65,
0x67,
0x63,
0xff,  // DQT
0xdb,
0x00,
0x43,  // Lq = 67
0x01,  // Pq = 0, Tq = 1
0x11,
0x12,
0x12,
0x18,
0x15,
0x18,
0x2f,
0x1a,
0x1a,
0x2f,
0x63,
0x42,
0x38,
0x42,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
0x63,
},
};  
    

