/*=============================================================*
 *  _  _             ___              _              _         *
 * | \| |   _  _    | _ )     _ _    (_)     __     | |__      *
 * | .` |  | +| |   | _ \    | '_|   | |    / _|    | / /      *
 * |_|\_|   \_,_|   |___/   _|_|_   _|_|_   \__|_   |_\_\      *
 *_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|     *
 *"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'     *
 *                                                             *
 * NuBrick IoT applications firmware                           *
 *                                                             *
 * Written by MB40 for Nuvoton Technology.                     *
 * tlshen@nuvoton.com/tzulan611126@gmail.com                   *
 * HCHEISH@nuvoton.com                                         *
 *=============================================================*
 */

#include "i2c0.h"

unsigned char  I2CMS_SlvRxData[64] = {0};                                //Store Received data in slave
unsigned char  I2CMS_SlvTxDevDesData[32] = {0};                   //Device Descript Data be transfered from slave
unsigned char  I2CMS_SlvTxRPDesData[80] = {0};                        //Report Descript Data be transfered from slave
unsigned char  I2CMS_SlvTxInRPData[32] = {0};                     //Input Report Data be transfered from slave
unsigned char  I2CMS_SlvTxGetFTData[32] = {0};                        //Get Feature Data be transfered from slave
unsigned char  I2CMS_SlvDataIndex = 0;                        //Get Feature Data be transfered from slave
unsigned char  I2CSlvDev;                                                                    //Master send command to slave
unsigned char  I2CSlvCmd;                                                                 //Master send command to slave
unsigned char  I2CSlv_InitFlag = 0;                       //I2C Slave device initialized falg
unsigned char  I2CSlv_readyFlag = 0;                  //I2C Slave device ready falg
unsigned char  I2CSlvDataLen;                                     //data length
unsigned char  I2CSlvBuffAddr;                                    //orgined address           //****
unsigned char  I2CSlvState;                                       //I2C Slave Receive state
unsigned char  I2CSlvStage;                                       //I2C Slave Receive state
unsigned char  I2CMS_SlvRxFin;                                //I2C Slave Receive complete flag

unsigned short tidReg[10] = {TID_REG_ONE, TID_REG_TWO, TID_REG_THR, TID_REG_FOUR, TID_REG_FIVE, TID_REG_SIX, TID_REG_SEV, TID_REG_EIG, TID_REG_NINE, TID_REG_TEN};

void I2C_init()
{
    /* initialize I2C */
    Wire.begin(0x16);
    Wire.onReceive(receiveEvent);
    Wire.onRequest(requestEvent);
}

// I2C response data test
void requestEvent() {
    int cmd = 0;
    int I2CDataEndBit;

    I2CSlvCmd = I2CMS_SlvRxData[0] | I2CMS_SlvRxData[1] << 8;
    switch(I2CSlvCmd)
    {
        case 1:
            I2CDataEndBit = I2CMS_SlvTxDevDesData[0];
            Wire.write(I2CMS_SlvTxDevDesData, I2CDataEndBit);
            break;
        case 2:
            I2CDataEndBit = I2CMS_SlvTxRPDesData[0];
            Wire.write(I2CMS_SlvTxRPDesData, I2CDataEndBit);
            break;
        case 3:
            I2CDataEndBit = I2CMS_SlvTxInRPData[0];
            Wire.write(I2CMS_SlvTxInRPData, I2CDataEndBit);
            break;
        case 5:
            I2CDataEndBit = I2CMS_SlvTxGetFTData[0];
            Wire.write(I2CMS_SlvTxGetFTData, I2CDataEndBit);
            break;
    }
    
    
}

// I2C receive data test
void receiveEvent(int howMany) {
    I2CMS_SlvDataIndex = 0;
    while (Wire.available() >= 1)
    {
        I2CMS_SlvRxData[I2CMS_SlvDataIndex] = Wire.read();
        I2CMS_SlvDataIndex++;
    }
        I2CMS_SlvRxData[I2CMS_SlvDataIndex] = Wire.read();
        I2CMS_SlvDataIndex = 0;
     Serial.print('H');
}
