package com.nuvoton.slidetab;

/**
 * Created by SLMeng on 2016/1/8.
 */

import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;

import java.util.ArrayList;
import java.util.List;

/**
 * ViewPager������
 */
public class MyPagerAdapter extends PagerAdapter {
    public List<View> mListViews;
    public List<String> mListTitles;
    public List<Integer> mListTitlesLight;
    public List<Integer> mListTitlesDark;

    public MyPagerAdapter(List<View> mListViews,List<String> mListTitles,List<Integer> mListTitlesLight,List<Integer> mListTitlesDark) {
        this.mListViews = mListViews;
        this.mListTitles =mListTitles;
        this.mListTitlesLight = mListTitlesLight;
        this.mListTitlesDark = mListTitlesDark;
    }

    @Override
    public void destroyItem(View arg0, int arg1, Object arg2) {
        ((ViewPager) arg0).removeView(mListViews.get(arg1));
    }

    @Override
    public void finishUpdate(View arg0) {
    }

    @Override
    public int getCount() {
        return mListViews.size();
    }

    @Override
    public Object instantiateItem(View arg0, int arg1) {
        ((ViewPager) arg0).addView(mListViews.get(arg1), 0);
        return mListViews.get(arg1);
    }
    public Integer getPageTitleLight(int position){
        return  mListTitlesLight.get(position);
    }
    public Integer getPageTitleDark(int position){
        return  mListTitlesDark.get(position);
    }

    @Override
    public CharSequence getPageTitle(int position) {
        return mListTitles.get(position);
    }

    @Override
    public boolean isViewFromObject(View arg0, Object arg1) {
        return arg0 == (arg1);
    }

    @Override
    public void restoreState(Parcelable arg0, ClassLoader arg1) {
    }

    @Override
    public Parcelable saveState() {
        return null;
    }

    @Override
    public void startUpdate(View arg0) {
    }
}