/*---------------------------------------------------------------------------------------------------------*/
/*                                                                                                         */
/* Copyright(c) 2019 Nuvoton Technology Corp. All rights reserved.                                         */
/*                                                                                                         */
/*---------------------------------------------------------------------------------------------------------*/

/***********************************************************************************************************/
/*  Website: http://www.nuvoton.com                                                                        */
/*  E-Mail : MicroC-8bit@nuvoton.com                                                                       */
/*  Date   : June/21/2019                                                                                   */
/***********************************************************************************************************/
#include "MS51_32K_IAR.h"


unsigned char PRINTFG,uart0_receive_flag,uart1_receive_flag;
unsigned char uart0_receive_data,uart1_receive_data;

struct BitFlag
{   unsigned char uart0_receive_flag: 1;
    unsigned char uart1_receive_flag: 1;
    unsigned char PRINTFG: 1;
}Flag;

#pragma vector=0x23
__interrupt void SerialPort0_ISR(void){
    _push_(SFRS);
    
      if (RI)
    {   
      uart0_receive_flag = 1;
      uart0_receive_data = SBUF;
      clr_SCON_RI;                                         // Clear RI (Receive Interrupt).
    }
    if  (TI)
    {
      if(!PRINTFG)
      {
          clr_SCON_TI;
      }
    }

    _pop_(SFRS);
}

#pragma vector=0x7B
__interrupt void SerialPort1_ISR(void){
    _push_(SFRS);
  
    if (RI_1==1) 
    {                                       
        clr_SCON_1_RI_1;                            
       uart1_receive_data = SBUF_1;
        uart1_receive_flag =1;
    }
    if(TI_1==1)
    {
       if(!PRINTFG)
      {
          clr_SCON_1_TI_1;                            
      }  
    }

    _pop_(SFRS);
}

/*MS51 new version buadrate */
void UART_Open(unsigned long u32SysClock, unsigned char u8UARTPort,unsigned long u32Baudrate)
{
  switch(u8UARTPort)
  {
    case UART0_Timer1:
          P06_QUASI_MODE;         //Setting UART pin as Quasi mode for transmit
          SCON = 0x50;            //UART0 Mode1,REN=1,TI=1
          TMOD |= 0x20;           //Timer1 Mode1
          set_PCON_SMOD;          //UART0 Double Rate Enable
          set_CKCON_T1M;
          clr_T3CON_BRCK;          //Serial port 0 baud rate clock source = Timer1
          TH1 = 256 - (u32SysClock/16/u32Baudrate);
          set_TCON_TR1;
//          set_IE_ES;
      break;
      
      case UART0_Timer3:
          P06_QUASI_MODE;    //Setting UART pin as Quasi mode for transmit
          SCON = 0x50;          //UART0 Mode1,REN=1,TI=1
          set_PCON_SMOD;        //UART0 Double Rate Enable
          T3CON &= 0xF8;        //T3PS2=0,T3PS1=0,T3PS0=0(Prescale=1)
          set_T3CON_BRCK;        //UART0 baud rate clock source = Timer3
          RH3    = HIBYTE(65536 - (u32SysClock/16/u32Baudrate));  
          RL3    = LOBYTE(65536 - (u32SysClock/16/u32Baudrate));  
          set_T3CON_TR3;         //Trigger Timer3
          set_IE_ES;
      break;
      
      case UART1_Timer3:
          P16_QUASI_MODE;       //Setting UART pin as Quasi mode for transmit
          P02_INPUT_MODE;       //Setting RXD_1 pin as Input mode for transmit   
          SCON_1 = 0x50;        //UART1 Mode1,REN_1=1,TI_1=1
          T3CON = 0x80;         //T3PS2=0,T3PS1=0,T3PS0=0(Prescale=1), UART1 in MODE 1
          RH3    = HIBYTE(65536 - (u32SysClock/16/u32Baudrate));  
          RL3    = LOBYTE(65536 - (u32SysClock/16/u32Baudrate));     
          set_T3CON_TR3;             //Trigger Timer3
          set_EIE1_ES_1;
      break;
  }
 //     ENABLE_GLOBAL_INTERRUPT;
}

unsigned char Receive_Data(unsigned char UARTPort)
{
    UINT8 c;
    switch (UARTPort)
    {
      case UART0:
        while (!RI);
        c = SBUF;
        RI = 0;
      break;
      case UART1:
        while (!RI_1);
        c = SBUF_1;
        RI_1 = 0;
      break;
    }
    return (c);
}

void UART_Send_Data(unsigned char UARTPort, unsigned char c)
{
    switch (UARTPort)
    {
      case UART0:
        TI = 0 ;
        SBUF = c;
        while (!TI);
      break;
      case UART1:
        TI_1 = 0;
        SBUF_1 = c;
        while (!TI_1);
      break;
    }
}

void printf_UART(unsigned char *str, ...);

void printInteger(unsigned long u32Temp)
{
    unsigned char print_buf[16];
    unsigned long i = 15, j;

    *(print_buf + i) = '\0';
    j = u32Temp >> 31;
    if(j)
        u32Temp = ~u32Temp + 1;
    do
    {
        i--;
        *(print_buf + i) = '0' + u32Temp % 10;
        u32Temp = u32Temp / 10;
    }
    while(u32Temp != 0);
    if(j)
    {
        i--;
        *(print_buf + i) = '-';
    }
    printf_UART(print_buf + i);
}
void printHex(unsigned long u32Temp)
{
    unsigned char print_buf[16];
    unsigned long i = 15;
    unsigned long temp;

    *(print_buf + i) = '\0';
    do
    {
        i--;
        temp = u32Temp % 16;
        if(temp < 10)
            *(print_buf + i) = '0' + temp;
        else
            *(print_buf + i) = 'a' + (temp - 10) ;
        u32Temp = u32Temp / 16;
    }
    while(u32Temp != 0);
    printf_UART(print_buf + i);
}
void printf_UART(unsigned char *str, ...)
{
    va_list args;
    va_start(args, str);
    while(*str != '\0')
    {
        if(*str == '%')
        {
            str++;
            if(*str == '\0') return;
            if(*str == 'd')
            {
                str++;
                printInteger(va_arg(args, int));
            }
            else if(*str == 'x')
            {
                str++;
                printHex(va_arg(args, int));
            }
        }
        UART_Send_Data(UART0,*str++);
    }
}
