/******************************************************************************
 * @file     main.c
 * @version  V1.00
 * $Revision: 1 $
 * $Date: 2020/07/20 11:28 $
 * @brief    Use WDT to wake system up from power-down mode periodically
 * @note
 * Copyright (C) 2020 Nuvoton Technology Corp. All rights reserved.
*****************************************************************************/
#include <stdio.h>
#include "NM1240.h"


void WDT_IRQHandler(void)
{

    /* Clear WDT interrupt flag */
    WDT_CLEAR_TIMEOUT_INT_FLAG();

    /* Check WDT wake up flag */
    if(WDT_GET_TIMEOUT_WAKEUP_FLAG()) {
        printf("Wake up by WDT\n");
        /* Clear WDT wake up flag */
        WDT_CLEAR_TIMEOUT_WAKEUP_FLAG();
				PA0 = ~PA0;
    }
}

void SYS_Init(void)
{
    /* Unlock protected registers */
    SYS_UnlockReg();

	 /* Set Core Clock as 60MHz HIRC */
    CLK_SetCoreClock(FREQ_60MHZ);
	
    /* Enable IP clock */
    CLK_EnableModuleClock(USCI2_MODULE);
    CLK_EnableModuleClock(WDT_MODULE);

    /* Select IP clock source */
    CLK_SetModuleClock(WDT_MODULE, CLK_WDT_SRC_LIRC, 0);

    /* USCI-Uart2-GPF1(TX) + GPF2(RX) */
    /* Set GPF multi-function pins for USCI UART2 GPF1(TX) and GPF2(RX) */
    SYS->GPF_MFP = (SYS->GPF_MFP & ~(SYS_GPF_MFP_PF1MFP_Msk | SYS_GPF_MFP_PF2MFP_Msk)) | (SYS_GPF_MFP_PF1_UART2_TXD | SYS_GPF_MFP_PF2_UART2_RXD);

    /* Set GPF1 as output mode and GPF2 as Input mode */
    GPIO_SetMode(PF, BIT1, GPIO_MODE_OUTPUT);
    GPIO_SetMode(PF, BIT2, GPIO_MODE_INPUT);

    /* Lock protected registers */
    SYS_LockReg();
}


int main()
{
    SYS_Init();

    /* Init USCI UART2 to 115200-8n1 for print message */
    UUART_Open(UUART2, 115200);

    printf("\nThis sample code demonstrate using WDT to wake system up from power down mode\n");

    /* WDT register is locked, so it is necessary to unlock protect register before configure WDT */
    SYS_UnlockReg();

    /* WDT timeout every 2^14 WDT clock, disable system reset, enable wake up system */
    WDT_Open(WDT_TIMEOUT_2POW14, 0, FALSE, TRUE);

    /* Enable WDT timeout interrupt */
    WDT_EnableInt();
    NVIC_EnableIRQ(WDT_IRQn);
	
		/*Set PA0 as indicator */
		GPIO_SetMode(PA, BIT0, GPIO_MODE_OUTPUT);
	
    while(1) {
        /* Wait USCI UART buffer empty to get a cleaner console out */		
        UUART_CLR_PROT_INT_FLAG(UUART2, UUART_PROTSTS_TXENDIF_Msk | UUART_PROTSTS_TXSTIF_Msk);			
        while(!UUART_IS_TX_EMPTY(UUART2));
        if(UUART_GET_PROT_STATUS(UUART2) & UUART_PROTSTS_TXSTIF_Msk)
            while((UUART_GET_PROT_STATUS(UUART2) & UUART_PROTSTS_TXENDIF_Msk) != UUART_PROTSTS_TXENDIF_Msk);
        CLK_PowerDown();
    }
}

/*** (C) COPYRIGHT 2018 Nuvoton Technology Corp. ***/
