/******************************************************************************
 * @file     main.c
 * @version  V1.00
 * $Revision: 3 $
 * $Date: 2020/07/20 14:20 $
 * @brief    Use timer to wake up system from Power-down mode periodically.
 * @note
 * Copyright (C) 2020 Nuvoton Technology Corp. All rights reserved.
*****************************************************************************/
#include <stdio.h>
#include "NM1240.h"


void TMR0_IRQHandler(void)
{
    /* Clear wake up flag */
    TIMER_ClearWakeupFlag(TIMER0);
    
    /* Clear interrupt flag */
    TIMER_ClearIntFlag(TIMER0);
}

void SYS_Init(void)
{
    /* Unlock protected registers */
    SYS_UnlockReg();

    /* Enable 60MHz HIRC */
    CLK_SetCoreClock(FREQ_60MHZ);
    
    /* Enable IP clock */
    CLK_EnableModuleClock(USCI2_MODULE);
    CLK_EnableModuleClock(TMR0_MODULE);

    /* Select IP clock source */
    CLK_SetModuleClock(TMR0_MODULE, CLK_TMR0_SRC_LIRC, 0);

    /* Update System Core Clock */
    /* User can use SystemCoreClockUpdate() to calculate SystemCoreClock and cyclesPerUs automatically. */
    SystemCoreClockUpdate();

    /* USCI-Uart2-GPF1(TX) + GPF2(RX) */
    /* Set GPF multi-function pins for USCI UART2 GPF1(TX) and GPF2(RX) */
    SYS->GPF_MFP = (SYS->GPF_MFP & ~(SYS_GPF_MFP_PF1MFP_Msk | SYS_GPF_MFP_PF2MFP_Msk)) | (SYS_GPF_MFP_PF1_UART2_TXD | SYS_GPF_MFP_PF2_UART2_RXD);

    /* Set GPF1 as output mode and GPF2 as Input mode */
    GPIO_SetMode(PF, BIT1, GPIO_MODE_OUTPUT);
    GPIO_SetMode(PF, BIT2, GPIO_MODE_INPUT);

    /* Lock protected registers */
    SYS_LockReg();
		
}


int main()
{
    int i = 0;

    SYS_Init();

    /* Init USCI UART2 to 115200-8n1 for print message */
    UUART_Open(UUART2, 115200);

    /*Initial Timer0 to periodic mode with 1Hz */
    TIMER_Open(TIMER0, TIMER_PERIODIC_MODE, 1);
    
    /* Enable timer wake up system */
    TIMER_EnableWakeup(TIMER0);
    
    /* Enable Timer0 interrupt */
    TIMER_EnableInt(TIMER0);
    NVIC_EnableIRQ(TMR0_IRQn);
    
    /* Start Timer0 counting */
    TIMER_Start(TIMER0);
    
    /* Unlock protected registers */
    SYS_UnlockReg();	

		/* Set PA0 as indicator*/
    GPIO_SetMode(PA, BIT0, GPIO_MODE_OUTPUT);
    
    while(1) {
        CLK_PowerDown();
        printf("Wake %d\n", i++);
				PA0 = ~PA0;

        /* Wait USCI UART buffer empty to get a cleaner console out	*/	
        UUART_CLR_PROT_INT_FLAG(UUART2, UUART_PROTSTS_TXENDIF_Msk | UUART_PROTSTS_TXSTIF_Msk);			
        while(!UUART_IS_TX_EMPTY(UUART2));
        if(UUART_GET_PROT_STATUS(UUART2) & UUART_PROTSTS_TXSTIF_Msk)
            while((UUART_GET_PROT_STATUS(UUART2) & UUART_PROTSTS_TXENDIF_Msk) != UUART_PROTSTS_TXENDIF_Msk);	        
    }
}

/*** (C) COPYRIGHT 2020 Nuvoton Technology Corp. ***/
