/******************************************************************************
 * @file     main.c
 * @version  V1.00
 * $Revision: 1 $
 * $Date: 2020/07/23 10:29 $
 * @brief    Main code on APROM
 * @note
 * Copyright (C) 2020 Nuvoton Technology Corp. All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include "NM1240.h"

extern void CodeOnSPROM0(void);
extern int CodeOnSPROM1(int cnt);
extern int CodeOnSPROM2(void);

int cnt = 0;

void SYS_Init(void)
{
    /* Unlock protected registers */
    SYS_UnlockReg();

    CLK_SetCoreClock(FREQ_60MHZ);

    /* Enable USCI2 IP clock */
    CLK_EnableModuleClock(USCI2_MODULE);

    /* USCI-Uart2-GPF1(TX) + GPF2(RX) */
    /* Set GPF multi-function pins for USCI UART2 GPF1(TX) and GPF2(RX) */
    SYS->GPF_MFP = (SYS->GPF_MFP & ~(SYS_GPF_MFP_PF1MFP_Msk | SYS_GPF_MFP_PF2MFP_Msk)) | (SYS_GPF_MFP_PF1_UART2_TXD | SYS_GPF_MFP_PF2_UART2_RXD);

    /* Set GPF1 as output mode and GPF2 as Input mode */
    PF->MODE = (PF->MODE & ~(GPIO_MODE_MODE1_Msk | GPIO_MODE_MODE2_Msk)) | (GPIO_MODE_OUTPUT << GPIO_MODE_MODE1_Pos);
	
    /* Lock protected registers */
    SYS_LockReg();	
}

int main (void)
{
    SYS_Init();

    /* Init USCI UART2 to 115200-8n1 for print message */
    UUART_Open(UUART2, 115200);	
		
    printf("+-----------------------------------------+\n");
    printf("|         Sample Code for SPROM           |\n");
    printf("+-----------------------------------------+\n");

    CodeOnSPROM0();
    printf("cnt = %d\n", cnt);
    cnt = CodeOnSPROM1(cnt);
    printf("cnt = %d\n", cnt);
    cnt = CodeOnSPROM2();
    printf("cnt = %d\n", cnt);

	
    while(1);
}

/*** (C) COPYRIGHT 2020 Nuvoton Technology Corp. ***/
