/******************************************************************************
 * @file     main.c
 * @version  V1.00
 * $Revision: 1 $
 * $Date: 2020/07/16 13:39 $
 * @brief    Sample code for System clock output to CLKO pin.
 * @note
 * Copyright (C) 2020 Nuvoton Technology Corp. All rights reserved.
*****************************************************************************/
#include <stdio.h>
#include "NM1240.h"


void SYS_Init(void)
{
    int32_t i32TimeOutCnt = 2160000;

    /* Unlock protected registers */
    SYS_UnlockReg();

    /* Enable 60MHz HIRC */
    CLK->PWRCTL |= CLK_PWRCTL_HIRC_SEL_Msk | CLK_PWRCTL_HIRCEN_Msk;

    /* Waiting for 72MHz clock ready */
    while((CLK->STATUS & CLK_STATUS_HIRCSTB_Msk) != CLK_STATUS_HIRCSTB_Msk) {
        if(i32TimeOutCnt-- <= 0) break;
    }

    /* HCLK Clock source from HIRC */
    CLK->CLKSEL0 = CLK->CLKSEL0 | CLK_HCLK_SRC_HIRC;

    /* Enable USCI2 IP clock */
    CLK->APBCLK = CLK->APBCLK | CLK_APBCLK_USCI2CKEN_Msk;

    /* Update System Core Clock */
    /* User can use SystemCoreClockUpdate() to calculate SystemCoreClock and cyclesPerUs automatically. */
    SystemCoreClockUpdate();

    /* USCI-Uart2-GPF1(TX) + GPF2(RX) */
    /* Set GPF multi-function pins for USCI UART2 GPF1(TX) and GPF2(RX) */
    SYS->GPF_MFP = SYS->GPF_MFP & ~(SYS_GPF_MFP_PF1MFP_Msk | SYS_GPF_MFP_PF2MFP_Msk) | (SYS_GPF_MFP_PF1_UART2_TXD | SYS_GPF_MFP_PF2_UART2_RXD);

    /* Set GPF1 as output mode and GPF2 as Input mode */
    PF->MODE = (PF->MODE & ~(GPIO_MODE_MODE1_Msk | GPIO_MODE_MODE2_Msk)) | (GPIO_MODE_OUTPUT << GPIO_MODE_MODE1_Pos);

    /* Lock protected registers */
    SYS_LockReg();
}


void delay2s()
{
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */
    //CLK_SysTickDelay(200000);  /* delay 200ms */

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    SysTick->CTRL = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_ENABLE_Msk;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

    SysTick->LOAD = 200000 * CyclesPerUs;
    SysTick->VAL  = 0;
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

		SysTick->CTRL = 0;
}

void UUART2_Init(void)
{
	  /*---------------------------------------------------------------------------------------------------------*/
    /* Init USCI                                                                                               */
    /*---------------------------------------------------------------------------------------------------------*/
    /* Reset USCI2 */
    SYS->IPRST1 |=  SYS_IPRST1_USCI2RST_Msk;
    SYS->IPRST1 &= ~SYS_IPRST1_USCI2RST_Msk;

    /* Configure USCI2 as UART mode */
    UUART2->CTL = (2 << UUART_CTL_FUNMODE_Pos);                                 /* Set UART function mode */
    UUART2->LINECTL = UUART_WORD_LEN_8 | UUART_LINECTL_LSB_Msk;                 /* Set UART line configuration */
    UUART2->DATIN0 = (2 << UUART_DATIN0_EDGEDET_Pos);                           /* Set falling edge detection */
    UUART2->BRGEN = (25 << UUART_BRGEN_CLKDIV_Pos) | (9 << UUART_BRGEN_DSCNT_Pos) | (1 << UUART_BRGEN_PDSCNT_Pos); /* Set UART baud rate as 115200bps */
    UUART2->PROTCTL |= UUART_PROTCTL_PROTEN_Msk;                                /* Enable UART protocol */
}

int main()
{
    SYS_Init();

    /* Init USCI UART2 to 115200-8n1 for print message */
    UUART2_Init();

    /* printf("\n\nPDID 0x%08X\n", SYS_ReadPDID()); */    /* Display PDID */
    printf("\n\nPDID 0x%08X\n", (unsigned int)(SYS->PDID & SYS_PDID_PDID_Msk)); /* Display PDID */

    printf("CPU @ %dHz\n", SystemCoreClock);        /* Display System Core Clock */

    /*
     * This sample code will demonstrate how to output different clocks one after another 
     * to the same CLKO (PA0) pin.
     */
    printf("+-----------------------------------------+\n");
    printf("| NM1240 System Clock Output Sample Code  |\n");
    printf("+-----------------------------------------+\n");

    printf("Set GPA0 pin as CLKO output clock.\n");
    SYS->GPA_MFP = (SYS->GPA_MFP & ~SYS_GPA_MFP_PA0MFP_Msk) | SYS_GPA_MFP_PA0_CLKO;             /* GPA0 CLKO mode */
    PA->MODE = (PA->MODE & ~GPIO_MODE_MODE0_Msk) | (GPIO_MODE_OUTPUT << GPIO_MODE_MODE0_Pos);   /* GPA0 output mode */

    /* CLK_EnableModuleClock(CLKO_MODULE); */
    CLK->APBCLK |= CLK_APBCLK_CLKOCKEN_Msk;

    printf("CLKO = HCLK / 1 = %dHz.\n", SystemCoreClock);

    /* CLK_EnableCKO(CLK_CLKO_SRC_HCLK, 0, 1); */
    /*      CLK_SetModuleClock(CLKO_MODULE, u32ClkSrc, NULL); */
    CLK->CLKSEL1 = (CLK->CLKSEL1 &~ CLK_CLKSEL1_CLKOSEL_Msk) | CLK_CLKO_SRC_HCLK;
    /*      CKO = clock source / 2^(u32ClkDiv + 1) */
    CLK->CLKOCTL = (CLK->CLKOCTL & ~(CLK_CLKOCTL_FREQSEL_Msk | CLK_CLKOCTL_DIV1EN_Msk))
                    | ((0) << CLK_CLKOCTL_FREQSEL_Pos)
                    | ((1) << CLK_CLKOCTL_DIV1EN_Pos);
    /*      Enable CKO clock source */
    CLK->CLKOCTL |= CLK_CLKOCTL_CLKOEN_Msk;

    delay2s();

    printf("CLKO = HCLK / 2^(0+1) = %dHz.\n", SystemCoreClock/2);

    /* CLK_EnableCKO(CLK_CLKO_SRC_HCLK, 0, 0); */
    /*      CLK_SetModuleClock(CLKO_MODULE, u32ClkSrc, NULL); */
    CLK->CLKSEL1 = (CLK->CLKSEL1 &~ CLK_CLKSEL1_CLKOSEL_Msk) | CLK_CLKO_SRC_HCLK;
    /*      CKO = clock source / 2^(u32ClkDiv + 1) */
    CLK->CLKOCTL = (CLK->CLKOCTL & ~(CLK_CLKOCTL_FREQSEL_Msk | CLK_CLKOCTL_DIV1EN_Msk))
                    | ((0) << CLK_CLKOCTL_FREQSEL_Pos)
                    | ((0) << CLK_CLKOCTL_DIV1EN_Pos);
    /*      Enable CKO clock source */
    CLK->CLKOCTL |= CLK_CLKOCTL_CLKOEN_Msk;

    delay2s();

    printf("CLKO = HCLK / 2^(2+1) = %dHz.\n", SystemCoreClock/8);

    /* CLK_EnableCKO(CLK_CLKO_SRC_HCLK, 2, 0); */
    /*      CLK_SetModuleClock(CLKO_MODULE, u32ClkSrc, NULL); */
    CLK->CLKSEL1 = (CLK->CLKSEL1 &~ CLK_CLKSEL1_CLKOSEL_Msk) | CLK_CLKO_SRC_HCLK;
    /*      CKO = clock source / 2^(u32ClkDiv + 1) */
    CLK->CLKOCTL = (CLK->CLKOCTL & ~(CLK_CLKOCTL_FREQSEL_Msk | CLK_CLKOCTL_DIV1EN_Msk))
                    | ((2) << CLK_CLKOCTL_FREQSEL_Pos)
                    | ((0) << CLK_CLKOCTL_DIV1EN_Pos);
    /*      Enable CKO clock source */
    CLK->CLKOCTL |= CLK_CLKOCTL_CLKOEN_Msk;

    delay2s();

    SYS_UnlockReg();

    printf("CLKO = EXT / 1 = %luHz.\n", __EXT);
    /* CLK_EnableEXTCLK(); */
    CLK->PWRCTL |= CLK_PWRCTL_EXT_EN;
    
    /* CLK_EnableCKO(CLK_CLKO_SRC_EXT, 0, 1); */
    /*      CLK_SetModuleClock(CLKO_MODULE, u32ClkSrc, NULL); */
    CLK->CLKSEL1 = (CLK->CLKSEL1 &~ CLK_CLKSEL1_CLKOSEL_Msk) | CLK_CLKO_SRC_EXT;
    /*      CKO = clock source / 2^(u32ClkDiv + 1) */
    CLK->CLKOCTL = (CLK->CLKOCTL & ~(CLK_CLKOCTL_FREQSEL_Msk | CLK_CLKOCTL_DIV1EN_Msk))
                    | ((0) << CLK_CLKOCTL_FREQSEL_Pos)
                    | ((1) << CLK_CLKOCTL_DIV1EN_Pos);
    /*      Enable CKO clock source */
    CLK->CLKOCTL |= CLK_CLKOCTL_CLKOEN_Msk;

    delay2s();
    
    /* CLK_DisableEXTCLK(); */
    CLK->PWRCTL &= ~CLK_PWRCTL_EXT_EN;

    printf("CLKO = EXT / 2^(1+1) = %luHz.\n", __EXT/4);

    /* CLK_EnableEXTCLK(); */
    CLK->PWRCTL |= CLK_PWRCTL_EXT_EN;

    /* CLK_EnableCKO(CLK_CLKO_SRC_EXT, 1, 0); */
    /*      CLK_SetModuleClock(CLKO_MODULE, u32ClkSrc, NULL); */
    CLK->CLKSEL1 = (CLK->CLKSEL1 &~ CLK_CLKSEL1_CLKOSEL_Msk) | CLK_CLKO_SRC_EXT;
    /*      CKO = clock source / 2^(u32ClkDiv + 1) */
    CLK->CLKOCTL = (CLK->CLKOCTL & ~(CLK_CLKOCTL_FREQSEL_Msk | CLK_CLKOCTL_DIV1EN_Msk))
                    | ((1) << CLK_CLKOCTL_FREQSEL_Pos)
                    | ((0) << CLK_CLKOCTL_DIV1EN_Pos);
    /*      Enable CKO clock source */
    CLK->CLKOCTL |= CLK_CLKOCTL_CLKOEN_Msk;

    delay2s();

    /* CLK_DisableEXTCLK(); */
    CLK->PWRCTL &= ~CLK_PWRCTL_EXT_EN;

    SYS_LockReg();

    printf("=== THE END ===\n\n");
    while(1);
}

/*** (C) COPYRIGHT 2020 Nuvoton Technology Corp. ***/
