/******************************************************************************
 * @file     main.c
 * @version  V1.00
 * $Revision: 1 $
 * $Date: 2020/7/14  $
 * @brief    Sample code for ADC Independent Simple mode with Temperature Sensor input.
 * @note
 * Copyright (C) 2020 Nuvoton Technology Corp. All rights reserved.
*****************************************************************************/
#include <stdio.h>
#include "NM1240.h"


void SYS_Init(void)
{
    int32_t i32TimeOutCnt = 2160000;

    /* Unlock protected registers */
    SYS_UnlockReg();

    /* Enable 72MHz HIRC */
    CLK->PWRCTL |= CLK_PWRCTL_HIRC_SEL_Msk | CLK_PWRCTL_HIRCEN_Msk;

    /* Waiting for HIRC clock ready */
    while((CLK->STATUS & CLK_STATUS_HIRCSTB_Msk) != CLK_STATUS_HIRCSTB_Msk) {
        if(i32TimeOutCnt-- <= 0) break;
    }

    /* HCLK Clock source from HIRC */
    CLK->CLKSEL0 = CLK->CLKSEL0 | CLK_HCLK_SRC_HIRC;

    /* Enable USCI2 IP clock */
    CLK->APBCLK = CLK->APBCLK | CLK_APBCLK_USCI2CKEN_Msk;

    /* Update System Core Clock */
    /* User can use SystemCoreClockUpdate() to calculate SystemCoreClock and cyclesPerUs automatically. */
    SystemCoreClockUpdate();

    /* USCI-Uart2-GPF1(TX) + GPF2(RX) */
    /* Set GPF multi-function pins for USCI UART2 GPF1(TX) and GPF2(RX) */
    SYS->GPF_MFP = (SYS->GPF_MFP & ~(SYS_GPF_MFP_PF1MFP_Msk | SYS_GPF_MFP_PF2MFP_Msk)) | (SYS_GPF_MFP_PF1_UART2_TXD | SYS_GPF_MFP_PF2_UART2_RXD);

    /* Set GPF1 as output mode and GPF2 as Input mode */
    PF->MODE = (PF->MODE & ~(GPIO_MODE_MODE1_Msk | GPIO_MODE_MODE2_Msk)) | (GPIO_MODE_OUTPUT << GPIO_MODE_MODE1_Pos);

    /* Enable IP clock */
    CLK->APBCLK |= CLK_APBCLK_ADCCKEN_Msk;

    /* Reset Module */
    SYS->IPRST1 |= SYS_IPRST1_ADCRST_Msk;
    SYS->IPRST1 &= ~SYS_IPRST1_ADCRST_Msk;
	SYS->IVSCTL |= SYS_IVSCTL_VTEMPEN_Msk;  /* Enable Temperature Sensor */

    /* Select IP clock source */

    /*---------------------------------------------------------------------------------------------------------*/
    /* Init I/O Multi-function                                                                                 */
    /*---------------------------------------------------------------------------------------------------------*/

    /* Lock protected registers */
    SYS_LockReg();
}

uint32_t Data;
int main()
{
    char ch;

    SYS_Init();

    /* Init USCI UART2 to 115200-8n1 for print message */
    UUART_Open(UUART2, 115200);

    /* printf("\n\nPDID 0x%08X\n", SYS_ReadPDID()); */    /* Display PDID */
    printf("\n\nPDID 0x%08X\n", (unsigned int)(SYS->PDID & SYS_PDID_PDID_Msk)); /* Display PDID */

    printf("CPU @ %dHz\n", SystemCoreClock);        /* Display System Core Clock */

    /*
     * This sample code will convert ADC1 Temperature Sensor in Independent Simple mode
     * and print conversion results.
     */
    printf("+------------------------------------------------+\n");
    printf("| NM1240 ADC for Temperature Sensor Sample Code |\n");
    printf("+------------------------------------------------+\n");

    /* Enable ADC clock */
    CLK->APBCLK |= CLK_APBCLK_ADCCKEN_Msk;

    /* Reset IP */
    SYS->IPRST1 |= SYS_IPRST1_ADCRST_Msk;
    SYS->IPRST1 &= ~SYS_IPRST1_ADCRST_Msk;

	
	/*Clear ADC Channel select*/
	ADC->CS_CTL &= ~ADC_CS_CTL_ADC0CSEN_Msk;
	/*ADC1 Channel select Set ADC0 CH6,ADC1_CH6=ADC1_TEMP_SENSOR_DAT */
	ADC->CS_CTL |= ADC1CS_TEMP_SENSOR;
	
    ADC->CTL &= ~ADC_CTL_ADC1HWTRGEN_Msk;
   

    /* Configure ADC conversion mode to Independent Simple Mode */
    ADC->CTL = (ADC->CTL & ~ADC_CTL_ADCMODE_Msk) | (0x0 << ADC_CTL_ADCMODE_Pos);

    /* Configure ADC sample time to 5 ADC clocks */
    ADC->SMPCNT = (ADC->SMPCNT & (~ADC_SMPCNT_ADCSMPCNT_Msk)) | ((5 & 0xF) << ADC_SMPCNT_ADCSMPCNT_Pos);
    /* Enable ADC */
    ADC->CTL |= ADC_CTL_ADCEN_Msk;
    /* Begin to do ADC conversion. */
    ch = 0;
    ADC->STATUS = (ADC_STATUS_ADC1IF_Msk);

    while (ch != 'q')
    {
        /* software trigger ADC1 */
        ADC->CTL |= ADC_CTL_ADC1SWTRG_Msk;

        /* wait ADC1 completed by polling */
        while (!(ADC->STATUS & ADC_STATUS_ADC1IF_Msk));
        ADC->STATUS = ADC_STATUS_ADC1IF_Msk;
		Data = ADC->ADC1_DAT6;
        printf("Get ADC1 data6 = %d\n",ADC->ADC1_DAT6);
            

        printf("Press any key for next ADC conversion ... Press 'q' to quit.\n");
        ch = getchar();
    }

    /* ADC Close*/
    ADC->CS_CTL = (ADC0CS_VSS)       /* Switching to channel Vss to save power */
				| (ADC1CS_VSS);       /* Switching to channel Vss to save power */
    /* Disable ADC */
    ADC->CTL &= ~ADC_CTL_ADCEN_Msk;
    SYS->IPRST1 |= SYS_IPRST1_ADCRST_Msk;
    SYS->IPRST1 &= ~SYS_IPRST1_ADCRST_Msk;

    CLK->APBCLK &= ~CLK_APBCLK_ADCCKEN_Msk;

    printf("=== THE END ===\n\n");
    while(1);
}

/*** (C) COPYRIGHT 2020 Nuvoton Technology Corp. ***/
