#include <stdio.h>
#include "targetdev.h"
#include "usci_uart_transfer.h"
#include "isp_user.h"

void SYS_Init(void)
{
    int32_t i32TimeOutCnt = 2160000;
    
    /* Enable 60MHz HIRC */
    CLK->PWRCTL |= CLK_PWRCTL_HIRC_SEL_Msk | CLK_PWRCTL_HIRCEN_Msk;
		//CLK->PWRCTL |= CLK_PWRCTL_HIRCEN_Msk;
    /* Waiting for 60MHz clock ready */
    while((CLK->STATUS & CLK_STATUS_HIRCSTB_Msk) != CLK_STATUS_HIRCSTB_Msk) {
        if(i32TimeOutCnt-- <= 0) break;
    }

    /* HCLK Clock source from HIRC */
    CLK->CLKSEL0 = CLK->CLKSEL0 | CLK_HCLK_SRC_HIRC;

    /* Enable IP clock */
    CLK->APBCLK = CLK->APBCLK | CLK_APBCLK_USCI2CKEN_Msk;

    /* Update System Core Clock */
    /* User can use SystemCoreClockUpdate() to calculate SystemCoreClock and cyclesPerUs automatically. */
    SystemCoreClockUpdate();

    /* USCI-Uart2-GPF1(TX) + GPF2(RX) */
    /* Set GPF multi-function pins for USCI UART2 GPF1(TX) and GPF2(RX) */
    SYS->GPF_MFP = (SYS->GPF_MFP & ~(SYS_GPF_MFP_PF1MFP_Msk | SYS_GPF_MFP_PF2MFP_Msk)) | (SYS_GPF_MFP_PF1_UART2_TXD | SYS_GPF_MFP_PF2_UART2_RXD);

    /* Set GPF1 as output mode and GPF2 as Input mode */
    PF->MODE = (PF->MODE & ~(GPIO_MODE_MODE1_Msk | GPIO_MODE_MODE2_Msk)) | (GPIO_MODE_OUTPUT << GPIO_MODE_MODE1_Pos);
}

int main(void)
{
    uint32_t rcvsize_bak = 0;
    uint32_t checkcnt = 0;
    /* Unlock protected registers */
    SYS_UnlockReg();
    /* Init System, peripheral clock and multi-function I/O */
    SYS_Init();
    /* Init UART to 115200-8n1 */
    USCI2_Init();
    CLK->AHBCLK |= CLK_AHBCLK_ISPCKEN_Msk;
    FMC->ISPCTL |= FMC_ISPCTL_ISPEN_Msk;
    g_apromSize = GetApromSize();
    GetDataFlashInfo(&g_dataFlashAddr, &g_dataFlashSize);
    SysTick->LOAD = 300000 * CyclesPerUs;
    SysTick->VAL   = (0x00);
    SysTick->CTRL = SysTick->CTRL | SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_ENABLE_Msk;//using cpu clock

    while (1) {
        if (rcvsize_bak != rcvsize) {
            rcvsize_bak = rcvsize;
            checkcnt = 0;
        } else if (rcvsize_bak != 0) {
            checkcnt++;

            if (checkcnt > 1000) {
                // Check the first isp command must be CMD_CONNECT
                if ((rcvsize_bak == 64) && (inpw(uart_rcvbuf) == CMD_CONNECT)) {
                    __set_PRIMASK(1);
                    rcvsize = 0;
                    bUartDataReady = TRUE;
                    __set_PRIMASK(0);
                    goto _ISP;
                } else {
                    // Drop Invalid Data & Reset index pointer for UART Buffer
                    __set_PRIMASK(1);
                    rcvsize = 0;
                    bufhead = 0;
                    bUartDataReady = FALSE;
                    __set_PRIMASK(0);
                    rcvsize_bak = 0;
                }
            }
        }

        if (SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) {
            goto _APROM;
        }
    }

_ISP:

    while (1) {
        if (bUartDataReady == TRUE) {
            bUartDataReady = FALSE;
            ParseCmd(uart_rcvbuf, 64);
            PutString();
            rcvsize_bak = 0;
            rcvsize = 0;
        }

        if (rcvsize_bak != rcvsize) {
            rcvsize_bak = rcvsize;
            checkcnt = 0;
        } else if (rcvsize_bak != 0) {
            checkcnt++;

            if (checkcnt > 1000) {
                if (rcvsize_bak == 64) {
                    __set_PRIMASK(1);
                    rcvsize = 0;
                    bUartDataReady = TRUE;
                    __set_PRIMASK(0);
                    // continue;
                } else {
                    // Drop Invalid Data & Reset index pointer for UART Buffer
                    __set_PRIMASK(1);
                    rcvsize = 0;
                    bufhead = 0;
                    __set_PRIMASK(0);
                }
            }
        }
    }

_APROM:
    SYS->RSTSTS = (SYS_RSTSTS_PORF_Msk | SYS_RSTSTS_PINRF_Msk);
    FMC->ISPCTL &= ~(FMC_ISPCTL_ISPEN_Msk | FMC_ISPCTL_BS_Msk);
    SCB->AIRCR = (V6M_AIRCR_VECTKEY_DATA | V6M_AIRCR_SYSRESETREQ);

    /* Trap the CPU */
    while (1);
}
