/*---------------------------------------------------------------------------------------------------------*/
/*                                                                                                         */
/* SPDX-License-Identifier: Apache-2.0                                                                     */
/* Copyright(c) 2025 Nuvoton Technology Corp. All rights reserved.                                         */
/*                                                                                                         */
/*---------------------------------------------------------------------------------------------------------*/

#include "numicro_8051.h"

uint8_t uart4rvbuffer;
BIT uart4rvflag;

/**
 * @brief       SC3 interrupt vector
 * @param       None
 * @return      None
 * @details     Store receive data.
 */
#if 0
void SC2_ISR(void) interrupt 23          // Vector @  0x9B
{
    PUSH_SFRS;
        SFRS =2;
        uart4rvflag = 1;
        uart4rvbuffer = SC2DR;
    POP_SFRS;
}
#endif
/**
 * @brief       UART3 transfer data without interrupt 
 * @param       u32SysClock , define Fsys value(value)
 * @param       u32Baudrate, Define baudrate (value)
 * @return      none
 * @details     none
 * @example:    UART3_Open(24000000,115200)
 */ 
void UART4_Open(uint32_t u32SysClock, uint32_t u32Baudrate)
{
    set_SC2CR0_SCEN;         /* Enable SC module */
    set_SC2CR1_UARTEN;       /* set as UART mode */
    set_SC2CR1_CLKKEEP;      
    clr_SC2CR0_CONSEL;       /* clr CONSEL and AUTOCEN*/
    clr_SC2CR0_AUTOCEN;
    SC2ETURD0 = LOBYTE(u32SysClock/8/u32Baudrate-1);  /* define baud rate low byte */
    SC2ETURD1 &= 0xF0;                                /* define baud rate high byte */
    SC2ETURD1 |= (HIBYTE(u32SysClock/8/u32Baudrate-1))&0x0F; 
    set_SC2CR1_PBOFF;     //parity bit disable
    SC2CR1&=0xCF;        //datalegth 8bit
    set_SC2CR0_NSB;      //stop bit = 1bit
  }

/**
 * @brief       UART2 Parity Enable / Disable Setting 
 * @param       Enable / Disable
 * @return      none
 * @details     none
 * @example:    UART2_Parity(ENBALE,SCPODD)
 */ 
void UART4_Parity(uint8_t u8PStatus, uint8_t u8PEvenOdd)
{
    SFRS_TMP = SFRS;
    if (u8PStatus==DISABLE)
      {
        set_SC0CR1_PBOFF;
      }
      else if (u8PStatus==ENABLE)
      {
        clr_SC2CR1_PBOFF;
        if (u8PEvenOdd==SC2PEVEN)
        {
          clr_SC2CR1_OPE;
        }
        else if (u8PEvenOdd==SC2PODD)
        {
          set_SC2CR1_OPE;
        }
      }
    SFRS = SFRS_TMP;
}
	
/**
 * @brief       UART3 receive data without interrupt 
 * @param       baudrate value
 * @return      received data
 * @details     none
 * @example:    temp = UART3_Receive_Data()
 */ 
uint8_t UART4_Receive_Data(void)
{
    uint8_t c;

    clr_SC2CR0_RXOFF;
    while(SC2TSR&SET_BIT1);
    c = SC1DR;
    return (c);
}

/**
 * @brief       UART3 transfer data without interrupt 
 * @param       baudrate value
 * @return      none
 * @details     none
 * @example:    UART3_Send_Data(0x55)
 */ 
void UART4_Send_Data(uint8_t c)
{
    clr_SC2CR0_TXOFF;
    SC2DR = c;
    while(!(SC2TSR&SET_BIT3));
    clr_SC2CR0_TXOFF;
}

